/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.utils.IntArrayList;
import java.util.Arrays;

public class BitArray {
    public static final BitArray EMPTY = new BitArray(0);
    final int[] data;
    final int size;

    private BitArray(int[] data, int size) {
        this.data = data;
        this.size = size;
    }

    public BitArray(int size) {
        this.size = size;
        this.data = new int[size + 31 >>> 5];
    }

    public BitArray(boolean[] array) {
        this(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            this.set(i);
        }
    }

    public void and(BitArray bitArray) {
        if (bitArray.size != this.size) {
            throw new IllegalArgumentException();
        }
        for (int i = this.data.length - 1; i >= 0; --i) {
            int n = i;
            this.data[n] = this.data[n] & bitArray.data[i];
        }
    }

    public void or(BitArray bitArray) {
        if (bitArray.size != this.size) {
            throw new IllegalArgumentException();
        }
        for (int i = this.data.length - 1; i >= 0; --i) {
            int n = i;
            this.data[n] = this.data[n] | bitArray.data[i];
        }
    }

    public void xor(BitArray bitArray) {
        if (bitArray.size != this.size) {
            throw new IllegalArgumentException();
        }
        for (int i = this.data.length - 1; i >= 0; --i) {
            int n = i;
            this.data[n] = this.data[n] ^ bitArray.data[i];
        }
    }

    public void not() {
        for (int i = this.data.length - 1; i >= 0; --i) {
            this.data[i] = ~this.data[i];
        }
        if (this.size > 0) {
            int n = this.data.length - 1;
            this.data[n] = this.data[n] & this.lastElementMask();
        }
    }

    int lastElementMask() {
        if ((this.size & 0x1F) == 0) {
            return -1;
        }
        return -1 >>> (this.data.length << 5) - this.size;
    }

    public int bitCount() {
        int bits = 0;
        for (int i : this.data) {
            bits += Integer.bitCount(i);
        }
        return bits;
    }

    public void clearAll() {
        Arrays.fill(this.data, 0);
    }

    public BitArray clone() {
        return new BitArray((int[])this.data.clone(), this.size);
    }

    public boolean intersects(BitArray bitArray) {
        if (bitArray.size != this.size) {
            throw new IllegalArgumentException();
        }
        for (int i = this.data.length - 1; i >= 0; --i) {
            if ((bitArray.data[i] & this.data[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public void loadValueFrom(BitArray bitArray) {
        System.arraycopy(bitArray.data, 0, this.data, 0, this.data.length);
    }

    public boolean get(int i) {
        return (this.data[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    public void set(int i) {
        int n = i >> 5;
        this.data[n] = this.data[n] | 1 << (i & 0x1F);
    }

    public void clear(int i) {
        int n = i >> 5;
        this.data[n] = this.data[n] & ~(1 << (i & 0x1F));
    }

    public void set(int i, boolean value) {
        if (value) {
            this.set(i);
        } else {
            this.clear(i);
        }
    }

    public void setAll(int[] positions, boolean value) {
        for (int i : positions) {
            this.set(i, value);
        }
    }

    public void setAll(IntArrayList positions, boolean value) {
        for (int i = positions.size() - 1; i >= 0; --i) {
            this.set(positions.get(i), value);
        }
    }

    public void setAll() {
        for (int i = this.data.length - 2; i >= 0; --i) {
            this.data[i] = -1;
        }
        if (this.size > 0) {
            this.data[this.data.length - 1] = this.lastElementMask();
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isFull() {
        if (this.size == 0) {
            return true;
        }
        for (int i = this.data.length - 2; i >= 0; --i) {
            if (this.data[i] == -1) continue;
            return false;
        }
        return this.data[this.data.length - 1] == this.lastElementMask();
    }

    public boolean isEmpty() {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if (this.data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public int[] getBits() {
        int[] bits = new int[this.bitCount()];
        int j = 0;
        if (this.size < 40 || this.size >> 2 < bits.length) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.get(i)) continue;
                bits[j++] = i;
            }
        } else {
            int i = -1;
            while ((i = this.nextBit(i + 1)) != -1) {
                if (!this.get(i) && j > 0) {
                    this.nextBit(bits[j - 1] + 1);
                }
                bits[j++] = i;
            }
        }
        assert (j == bits.length);
        return bits;
    }

    public int nextBit(int position) {
        int ret = position & 0x1F;
        if (ret != 0) {
            if ((ret = Integer.numberOfTrailingZeros(this.data[position >>> 5] >>> ret)) != 32) {
                return position + ret;
            }
            position += 32;
        }
        ret = 32;
        position >>>= 5;
        while (position < this.data.length && (ret = Integer.numberOfTrailingZeros(this.data[position++])) == 32) {
        }
        if (position >= this.data.length && ret == 32) {
            return -1;
        }
        return (position - 1 << 5) + ret;
    }

    public int nextZeroBit(int position) {
        int ret = position & 0x1F;
        if (ret != 0) {
            if ((ret = Integer.numberOfTrailingZeros(~this.data[position >>> 5] >>> ret)) != 32) {
                int r = position + ret;
                return r >= this.size() ? -1 : r;
            }
            position += 32;
        }
        ret = 32;
        position >>>= 5;
        while (position < this.data.length && (ret = Integer.numberOfTrailingZeros(~this.data[position++])) == 32) {
        }
        if (position >= this.data.length && ret == 32) {
            return -1;
        }
        int r = (position - 1 << 5) + ret;
        return r >= this.size() ? -1 : r;
    }

    public BitArray copyOfRange(int from, int to) {
        BitArray ba = new BitArray(to - from);
        ba.loadValueFrom(this, from, 0, to - from);
        return ba;
    }

    public BitArray copyOfRange(int from) {
        return this.copyOfRange(from, this.size);
    }

    public void loadValueFrom(BitArray bitArray, int sourceOffset, int thisOffset, int length) {
        if (bitArray == this) {
            throw new IllegalArgumentException("Can't copy from itself.");
        }
        int alignmentOffset = sourceOffset & 0x1F;
        sourceOffset >>>= 5;
        if (alignmentOffset != 0) {
            int l = Math.min(32 - alignmentOffset, length);
            this.loadValueFrom(bitArray.data[sourceOffset] >>> alignmentOffset, thisOffset, l);
            thisOffset += l;
            ++sourceOffset;
            length -= l;
        }
        while (length > 0) {
            this.loadValueFrom(bitArray.data[sourceOffset], thisOffset, Math.min(32, length));
            length -= 32;
            thisOffset += 32;
            ++sourceOffset;
        }
    }

    void loadValueFrom(int d, int position, int length) {
        if (length == 0) {
            return;
        }
        int res = position & 0x1F;
        position >>>= 5;
        int mask = -1 >>> 32 - length;
        if (res == 0) {
            if (length == 32) {
                this.data[position] = d;
            } else {
                int n = position;
                this.data[n] = this.data[n] & ~mask;
                int n2 = position;
                this.data[n2] = this.data[n2] | d & mask;
            }
            return;
        }
        int n = position;
        this.data[n] = this.data[n] & ~(mask << res);
        int n3 = position;
        this.data[n3] = this.data[n3] | (d & mask) << res;
        if ((length -= 32 - res) > 0) {
            this.loadValueFrom(d >>> 32 - res, position + 1 << 5, length);
        }
    }

    public BitArray append(BitArray other) {
        BitArray ba = new BitArray(this.size + other.size);
        System.arraycopy(this.data, 0, ba.data, 0, this.data.length);
        ba.loadValueFrom(other, 0, this.size, other.size);
        return ba;
    }

    public BitArray times(int times) {
        BitArray ba = new BitArray(times * this.size);
        if (times > 0) {
            System.arraycopy(this.data, 0, ba.data, 0, this.data.length);
        }
        for (int i = 1; i < times; ++i) {
            ba.loadValueFrom(this, 0, i * this.size, this.size);
        }
        return ba;
    }

    public String toString() {
        char[] c = new char[this.size];
        for (int i = 0; i < this.size; ++i) {
            c[i] = this.get(i) ? 49 : 48;
        }
        return new String(c);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitArray that = (BitArray)o;
        if (this.size != that.size) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.data);
        result = 31 * result + this.size;
        return result;
    }
}

