/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.HashFunctions;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.IntComparator;
import cc.redberry.core.utils.IntTimSort;
import cc.redberry.core.utils.MathUtils;
import cc.redberry.core.utils.ToStringConverter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;

public final class ArraysUtils {
    public static final Comparator<Object> HASH_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    };

    private ArraysUtils() {
    }

    public static void arraycopy(IntArray source, int srcPos, int[] dest, int destPos, int length) {
        System.arraycopy(source.innerArray, srcPos, dest, destPos, length);
    }

    public static int[] short2int(short[] a) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return r;
    }

    public static short[] int2short(int[] a) {
        short[] r = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = (short)a[i];
        }
        return r;
    }

    public static int[] byte2int(byte[] a) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return r;
    }

    public static short[] byte2short(byte[] a) {
        short[] r = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return r;
    }

    public static byte[] int2byte(int[] a) {
        byte[] r = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = (byte)a[i];
        }
        return r;
    }

    public static int max(int[] array) {
        int a = -1;
        for (int i : array) {
            a = Math.max(a, i);
        }
        return a;
    }

    public static int[] getSeriesFrom0(int size) {
        int[] ret = new int[size];
        for (int i = size; i >= 0; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public static int[][] deepClone(int[][] input) {
        int[][] res = new int[input.length][];
        for (int i = res.length - 1; i >= 0; --i) {
            res[i] = (int[])input[i].clone();
        }
        return res;
    }

    public static int sum(int[] array) {
        int s = 0;
        for (int i : array) {
            s += i;
        }
        return s;
    }

    public static <T> int[] bijection(T[] from, T[] to, Comparator<? super T> comparator) {
        if (from.length != to.length) {
            return null;
        }
        int length = from.length;
        int[] bijection = new int[length];
        Arrays.fill(bijection, -1);
        int i = 0;
        while (i < length) {
            block4: {
                for (int j = 0; j < length; ++j) {
                    if (bijection[j] != -1 || comparator.compare(from[i], to[j]) != 0) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            bijection[j] = i++;
        }
        return bijection;
    }

    public static <T extends Comparable<? super T>> int[] bijection(T[] from, T[] to) {
        if (from.length != to.length) {
            return null;
        }
        int length = from.length;
        int[] bijection = new int[length];
        Arrays.fill(bijection, -1);
        int i = 0;
        while (i < length) {
            block4: {
                for (int j = 0; j < length; ++j) {
                    if (bijection[j] != -1 || from[i].compareTo(to[j]) != 0) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            bijection[j] = i++;
        }
        return bijection;
    }

    public static Tensor[] addAll(Tensor[] array1, Tensor ... array2) {
        Tensor[] r = new Tensor[array1.length + array2.length];
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }

    public static int[] addAll(int[] array1, int ... array2) {
        int[] r = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }

    public static int[] addAll(int[] ... arrays) {
        int i;
        if (arrays.length == 0) {
            return new int[0];
        }
        int length = 0;
        for (i = 0; i < arrays.length; ++i) {
            length += arrays[i].length;
        }
        if (length == 0) {
            return new int[0];
        }
        int[] r = new int[length];
        int pointer = 0;
        for (i = 0; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, r, pointer, arrays[i].length);
            pointer += arrays[i].length;
        }
        return r;
    }

    public static Tensor[] remove(Tensor[] array, int i) {
        Tensor[] r = new Tensor[array.length - 1];
        System.arraycopy(array, 0, r, 0, i);
        if (i < array.length - 1) {
            System.arraycopy(array, i + 1, r, i, array.length - i - 1);
        }
        return r;
    }

    public static <T> T[] remove(T[] array, int i) {
        Object[] r = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        System.arraycopy(array, 0, r, 0, i);
        if (i < array.length - 1) {
            System.arraycopy(array, i + 1, r, i, array.length - i - 1);
        }
        return r;
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return (Object[])array2.clone();
        }
        if (array2 == null) {
            return (Object[])array1.clone();
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static <T> T[] remove(T[] array, int[] positions) {
        int pointer;
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = MathUtils.getSortedDistinct(positions);
        if (p.length == 0) {
            return array;
        }
        int size = p.length;
        int s = array.length;
        for (pointer = 0; pointer < size; ++pointer) {
            if (p[pointer] < s) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] r = (Object[])Array.newInstance(type, array.length - p.length);
        pointer = 0;
        int i = -1;
        for (int j = 0; j < s; ++j) {
            if (pointer < size - 1 && j > p[pointer]) {
                ++pointer;
            }
            if (j == p[pointer]) continue;
            r[++i] = array[j];
        }
        return r;
    }

    public static Tensor[] remove(Tensor[] array, int[] positions) {
        int pointer;
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = MathUtils.getSortedDistinct(positions);
        if (p.length == 0) {
            return array;
        }
        int size = p.length;
        int s = array.length;
        for (pointer = 0; pointer < size; ++pointer) {
            if (p[pointer] < s) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        Class<?> type = array.getClass().getComponentType();
        Tensor[] r = new Tensor[array.length - p.length];
        pointer = 0;
        int i = -1;
        for (int j = 0; j < s; ++j) {
            if (pointer < size - 1 && j > p[pointer]) {
                ++pointer;
            }
            if (j == p[pointer]) continue;
            r[++i] = array[j];
        }
        return r;
    }

    public static int[] remove(int[] array, int[] positions) {
        int pointer;
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = MathUtils.getSortedDistinct((int[])positions.clone());
        if (p.length == 0) {
            return array;
        }
        int size = p.length;
        int s = array.length;
        for (pointer = 0; pointer < size; ++pointer) {
            if (p[pointer] < s) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] r = new int[array.length - p.length];
        pointer = 0;
        int i = -1;
        for (int j = 0; j < s; ++j) {
            if (pointer < size - 1 && j > p[pointer]) {
                ++pointer;
            }
            if (j == p[pointer]) continue;
            r[++i] = array[j];
        }
        return r;
    }

    public static <T> T[] select(T[] array, int[] positions) {
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = MathUtils.getSortedDistinct(positions);
        Class<?> type = array.getClass().getComponentType();
        Object[] r = (Object[])Array.newInstance(type, p.length);
        int i = -1;
        for (int j : p) {
            r[++i] = array[j];
        }
        return r;
    }

    public static int[] toArray(Set<Integer> set) {
        int i = -1;
        int[] a = new int[set.size()];
        for (Integer ii : set) {
            a[++i] = ii;
        }
        return a;
    }

    public static void fill(IntArrayList list, int fromIndex, int toIndex, int value) {
        if (toIndex >= list.size()) {
            throw new IndexOutOfBoundsException();
        }
        Arrays.fill(list.data, fromIndex, toIndex, value);
    }

    public static void fill(IntArrayList list, int value) {
        ArraysUtils.fill(list, 0, list.size(), value);
    }

    public static int binarySearch(IntArrayList list, int key) {
        return Arrays.binarySearch(list.data, 0, list.size, key);
    }

    public static int binarySearch(IntArray array, int key) {
        return Arrays.binarySearch(array.innerArray, 0, array.innerArray.length, key);
    }

    public static int binarySearch1(int[] a, int key) {
        return ArraysUtils.binarySearch1(a, 0, a.length, key);
    }

    public static int binarySearch1(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            while (mid > 0 && a[mid - 1] == a[mid]) {
                --mid;
            }
            return mid;
        }
        if (low >= a.length) {
            return low;
        }
        while (low > 0 && a[low - 1] == a[low]) {
            --low;
        }
        return low;
    }

    public static int commutativeHashCode(Object[] objects) {
        if (objects == null) {
            return 0;
        }
        int hash = 0;
        for (Object o : objects) {
            hash ^= o == null ? 0 : o.hashCode();
        }
        return HashFunctions.JenkinWang32shift(hash);
    }

    public static int commutativeHashCode(Object[] objects, int from, int to) {
        ArraysUtils.rangeCheck(objects.length, from, to);
        if (objects == null) {
            return 0;
        }
        int hash = 0;
        for (int i = from; i < to; ++i) {
            hash ^= objects[i] == null ? 0 : objects[i].hashCode();
        }
        return HashFunctions.JenkinWang32shift(hash);
    }

    public static void insertionSort(int[] target, int[] coSort) {
        ArraysUtils.insertionSort(target, 0, target.length, coSort);
    }

    public static void insertionSort(int[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int key = target[i];
            int keyC = coSort[i];
            for (int j = i; j > fromIndex && target[j - 1] > key; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static void insertionSort(int[] target, long[] coSort) {
        ArraysUtils.insertionSort(target, 0, target.length, coSort);
    }

    public static void insertionSort(int[] target, int fromIndex, int toIndex, long[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int key = target[i];
            long keyC = coSort[i];
            for (int j = i; j > fromIndex && target[j - 1] > key; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static <T extends Comparable<T>> void insertionSort(T[] target, Object[] coSort) {
        ArraysUtils.insertionSort(target, (int)0, (int)target.length, (Object[])coSort);
    }

    public static <T extends Comparable<T>> void insertionSort(T[] target, int fromIndex, int toIndex, Object[] coSort) {
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            T key = target[i];
            Object keyC = coSort[i];
            for (int j = i; j > fromIndex && target[j - 1].compareTo(key) > 0; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static void timSort(int[] target, int[] coSort) {
        IntTimSort.sort(target, coSort);
    }

    public static void stableSort(int[] target, int[] cosort) {
        if (target.length > 100) {
            ArraysUtils.timSort(target, cosort);
        } else {
            ArraysUtils.insertionSort(target, cosort);
        }
    }

    public static int[] quickSortP(int[] target) {
        int[] permutation = new int[target.length];
        for (int i = 1; i < target.length; ++i) {
            permutation[i] = i;
        }
        ArraysUtils.quickSort(target, 0, target.length, permutation);
        return permutation;
    }

    public static void quickSort(int[] target, int[] coSort) {
        ArraysUtils.quickSort(target, 0, target.length, coSort);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, int[] coSort) {
        if (target == coSort) {
            throw new IllegalArgumentException("Target reference == coSort reference.");
        }
        ArraysUtils.quickSort2(target, fromIndex, length, coSort);
    }

    private static void quickSort2(int[] target, int fromIndex, int length, int[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtils.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtils.med3(target, m - s, m, m + s);
                n = ArraysUtils.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtils.med3(target, l, m, n);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtils.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtils.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort2(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort2(target, n - s, s, coSort);
        }
    }

    private static void swap(int[] x, int a, int b, int[] coSort) {
        ArraysUtils.swap(x, a, b);
        ArraysUtils.swap(coSort, a, b);
    }

    public static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n, int[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void quickSort(int[] target, long[] coSort) {
        ArraysUtils.quickSort1(target, 0, target.length, coSort);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, long[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, long[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtils.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtils.med3(target, m - s, m, m + s);
                n = ArraysUtils.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtils.med3(target, l, m, n);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtils.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtils.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort1(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort1(target, n - s, s, coSort);
        }
    }

    private static void swap(int[] x, int a, int b, long[] coSort) {
        ArraysUtils.swap(x, a, b);
        ArraysUtils.swap(coSort, a, b);
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n, long[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, Object[] coSort) {
        ArraysUtils.quickSort(target, (int)0, (int)target.length, (Object[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, int fromIndex, int toIndex, Object[] coSort) {
        if (target == coSort) {
            throw new IllegalArgumentException();
        }
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, (int)fromIndex, (int)(toIndex - fromIndex), (Object[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort1(T[] target, int fromIndex, int length, Object[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1].compareTo(target[j]) > 0; --j) {
                    ArraysUtils.swap((Object[])target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, (int)l, (int)(l + s), (int)(l + 2 * s));
                m = ArraysUtils.med3(target, (int)(m - s), (int)m, (int)(m + s));
                n = ArraysUtils.med3(target, (int)(n - 2 * s), (int)(n - s), (int)n);
            }
            m = ArraysUtils.med3(target, (int)l, (int)m, (int)n);
        }
        T v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b].compareTo(v) <= 0) {
                if (target[b] == v) {
                    ArraysUtils.swap((Object[])target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c].compareTo(v) >= 0) {
                if (target[c] == v) {
                    ArraysUtils.swap((Object[])target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap((Object[])target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap((Object[])target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap((Object[])target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort1(target, (int)fromIndex, (int)s, (Object[])coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort1(target, (int)(n - s), (int)s, (Object[])coSort);
        }
    }

    private static void swap(Object[] x, int a, int b, Object[] coSort) {
        ArraysUtils.swap(x, a, b);
        ArraysUtils.swap(coSort, a, b);
    }

    private static void vecswap(Object[] x, int a, int b, int n, Object[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, int[] coSort) {
        ArraysUtils.quickSort(target, (int)0, (int)target.length, (int[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, (int)fromIndex, (int)(toIndex - fromIndex), (int[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort1(T[] target, int fromIndex, int length, int[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1].compareTo(target[j]) > 0; --j) {
                    ArraysUtils.swap((Object[])target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, (int)l, (int)(l + s), (int)(l + 2 * s));
                m = ArraysUtils.med3(target, (int)(m - s), (int)m, (int)(m + s));
                n = ArraysUtils.med3(target, (int)(n - 2 * s), (int)(n - s), (int)n);
            }
            m = ArraysUtils.med3(target, (int)l, (int)m, (int)n);
        }
        T v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b].compareTo(v) <= 0) {
                if (target[b] == v) {
                    ArraysUtils.swap((Object[])target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c].compareTo(v) >= 0) {
                if (target[c] == v) {
                    ArraysUtils.swap((Object[])target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap((Object[])target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap((Object[])target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap((Object[])target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort1(target, (int)fromIndex, (int)s, (int[])coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort1(target, (int)(n - s), (int)s, (int[])coSort);
        }
    }

    private static void swap(Object[] x, int a, int b, int[] coSort) {
        ArraysUtils.swap(x, a, b);
        ArraysUtils.swap(coSort, a, b);
    }

    private static void vecswap(Object[] x, int a, int b, int n, int[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static <T extends Comparable<T>> int med3(T[] x, int a, int b, int c) {
        return x[a].compareTo(x[b]) < 0 ? (x[b].compareTo(x[c]) < 0 ? b : (x[a].compareTo(x[c]) < 0 ? c : a)) : (x[b].compareTo(x[c]) > 0 ? b : (x[a].compareTo(x[c]) > 0 ? c : a));
    }

    public static void quickSort(int[] target, Object[] coSort) {
        ArraysUtils.quickSort1(target, 0, target.length, coSort);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, Object[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, Object[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtils.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtils.med3(target, m - s, m, m + s);
                n = ArraysUtils.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtils.med3(target, l, m, n);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtils.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtils.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort1(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort1(target, n - s, s, coSort);
        }
    }

    private static void swap(int[] x, int a, int b, Object[] coSort) {
        ArraysUtils.swap(x, a, b);
        ArraysUtils.swap(coSort, a, b);
    }

    private static void vecswap(int[] x, int a, int b, int n, Object[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static int[] quickSortP(short[] target) {
        int[] permutation = new int[target.length];
        for (int i = 1; i < target.length; ++i) {
            permutation[i] = i;
        }
        ArraysUtils.quickSort(target, 0, target.length, permutation);
        return permutation;
    }

    public static void quickSort(short[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(short[] target, int fromIndex, int length, int[] coSort) {
        ArraysUtils.quickSort2(target, fromIndex, length, coSort);
    }

    private static void quickSort2(short[] target, int fromIndex, int length, int[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtils.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtils.med3(target, m - s, m, m + s);
                n = ArraysUtils.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtils.med3(target, l, m, n);
        }
        short v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtils.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtils.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort2(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort2(target, n - s, s, coSort);
        }
    }

    public static void quickSort(short[] target, int[] coSort) {
        ArraysUtils.quickSort(target, 0, target.length, coSort);
    }

    private static void swap(short[] x, int a, int b, int[] coSort) {
        ArraysUtils.swap(x, a, b);
        ArraysUtils.swap(coSort, a, b);
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(short[] x, int a, int b, int n, int[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void quickSort(int[] target, IntComparator comparator) {
        ArraysUtils.quickSort1(target, 0, target.length, comparator);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, IntComparator comparator) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtils.quickSort1(target, fromIndex, toIndex - fromIndex, comparator);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, IntComparator comparator) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && comparator.compare(target[j - 1], target[j]) > 0; --j) {
                    ArraysUtils.swap(target, j, j - 1);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, l, l + s, l + 2 * s, comparator);
                m = ArraysUtils.med3(target, m - s, m, m + s, comparator);
                n = ArraysUtils.med3(target, n - 2 * s, n - s, n, comparator);
            }
            m = ArraysUtils.med3(target, l, m, n, comparator);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && comparator.compare(target[b], v) <= 0) {
                if (comparator.compare(target[b], v) == 0) {
                    ArraysUtils.swap(target, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(target[c], v) >= 0) {
                if (comparator.compare(target[c], v) == 0) {
                    ArraysUtils.swap(target, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap(target, b++, c--);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap(target, fromIndex, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap(target, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort1(target, fromIndex, s, comparator);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort1(target, n - s, s, comparator);
        }
    }

    public static void quickSort(int[] target, int[] cosort, IntComparator comparator) {
        ArraysUtils.quickSort1(target, 0, target.length, cosort, comparator);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, int[] cosort, IntComparator comparator) {
        ArraysUtils.rangeCheck(target.length, fromIndex, toIndex);
        if (target == cosort) {
            throw new IllegalArgumentException("Same array references.");
        }
        ArraysUtils.quickSort1(target, fromIndex, toIndex - fromIndex, cosort, comparator);
    }

    private static void quickSort1(int[] target, int fromIndex, int length, int[] cosort, IntComparator comparator) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && comparator.compare(target[j - 1], target[j]) > 0; --j) {
                    ArraysUtils.swap(target, j, j - 1, cosort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtils.med3(target, l, l + s, l + 2 * s, comparator);
                m = ArraysUtils.med3(target, m - s, m, m + s, comparator);
                n = ArraysUtils.med3(target, n - 2 * s, n - s, n, comparator);
            }
            m = ArraysUtils.med3(target, l, m, n, comparator);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && comparator.compare(target[b], v) <= 0) {
                if (comparator.compare(target[b], v) == 0) {
                    ArraysUtils.swap(target, a++, b, cosort);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(target[c], v) >= 0) {
                if (comparator.compare(target[c], v) == 0) {
                    ArraysUtils.swap(target, c, d--, cosort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtils.swap(target, b++, c--, cosort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtils.vecswap(target, fromIndex, b - s, s, cosort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtils.vecswap(target, b, n - s, s, cosort);
        s = b - a;
        if (s > 1) {
            ArraysUtils.quickSort1(target, fromIndex, s, cosort, comparator);
        }
        if ((s = d - c) > 1) {
            ArraysUtils.quickSort1(target, n - s, s, cosort, comparator);
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comparator) {
        return comparator.compare(x[a], x[b]) < 0 ? (comparator.compare(x[b], x[c]) < 0 ? b : (comparator.compare(x[a], x[c]) < 0 ? c : a)) : (comparator.compare(x[b], x[c]) > 0 ? b : (comparator.compare(x[a], x[c]) > 0 ? c : a));
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ArraysUtils.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static <T> String toString(T[] a, ToStringConverter<T> format) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(format.toString(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(int[] a, ToStringConverter<Integer> format) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(format.toString(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

