/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.symmetrization;

import cc.redberry.core.combinatorics.IntPermutationsGenerator;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Rational;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SymmetrizeUpperLowerIndicesTransformation
implements Transformation {
    public static final SymmetrizeUpperLowerIndicesTransformation SYMMETRIZE_UPPER_LOWER_INDICES = new SymmetrizeUpperLowerIndicesTransformation();

    private SymmetrizeUpperLowerIndicesTransformation() {
    }

    @Override
    public Tensor transform(Tensor t) {
        return SymmetrizeUpperLowerIndicesTransformation.symmetrizeUpperLowerIndices(t);
    }

    public static Tensor symmetrizeUpperLowerIndices(Tensor tensor) {
        return SymmetrizeUpperLowerIndicesTransformation.symmetrizeUpperLowerIndices(tensor, false);
    }

    public static Tensor symmetrizeUpperLowerIndices(Tensor tensor, boolean multiplyOnSymmetryFactor) {
        Indices indices = IndicesFactory.create(tensor.getIndices().getFree());
        int[] indicesArray = indices.getAllIndices().copy();
        List<Permutation> symmetries = TensorUtils.getIndicesSymmetriesForIndicesWithSameStates(indicesArray, tensor);
        int lowerCount = indices.getLower().size();
        int upperCount = indices.getUpper().size();
        SumBuilder sumBuilder = new SumBuilder();
        ArrayList<int[]> generatedPermutations = new ArrayList<int[]>();
        if (upperCount != 0 && lowerCount != 0) {
            IntPermutationsGenerator lowIndicesPermutationsGenerator = new IntPermutationsGenerator(lowerCount);
            while (lowIndicesPermutationsGenerator.hasNext()) {
                int[] lowerPermutation = (int[])lowIndicesPermutationsGenerator.next().clone();
                for (int i = 0; i < lowerCount; ++i) {
                    lowerPermutation[i] = lowerPermutation[i] + upperCount;
                }
                IntPermutationsGenerator upperIndicesPermutationGenerator = new IntPermutationsGenerator(upperCount);
                while (upperIndicesPermutationGenerator.hasNext()) {
                    int[] upperPermutation = upperIndicesPermutationGenerator.next();
                    Tensor summand = SymmetrizeUpperLowerIndicesTransformation.permute(tensor, indicesArray, upperPermutation, lowerPermutation, generatedPermutations, symmetries);
                    if (summand == null) continue;
                    sumBuilder.put(summand);
                }
            }
        } else if (upperCount == 0) {
            IntPermutationsGenerator lowIndicesPermutationsGenerator = new IntPermutationsGenerator(lowerCount);
            while (lowIndicesPermutationsGenerator.hasNext()) {
                int[] lowerPermutation = lowIndicesPermutationsGenerator.next();
                Tensor summand = SymmetrizeUpperLowerIndicesTransformation.permute(tensor, indicesArray, new int[0], lowerPermutation, generatedPermutations, symmetries);
                if (summand == null) continue;
                sumBuilder.put(summand);
            }
        } else if (lowerCount == 0) {
            IntPermutationsGenerator upperIndicesPermutationGenerator = new IntPermutationsGenerator(upperCount);
            while (upperIndicesPermutationGenerator.hasNext()) {
                int[] upperPermutation = upperIndicesPermutationGenerator.next();
                Tensor summand = SymmetrizeUpperLowerIndicesTransformation.permute(tensor, indicesArray, upperPermutation, new int[0], generatedPermutations, symmetries);
                if (summand == null) continue;
                sumBuilder.put(summand);
            }
        }
        if (multiplyOnSymmetryFactor) {
            return Tensors.multiply(new Complex(new Rational(1, generatedPermutations.size())), sumBuilder.build());
        }
        return sumBuilder.build();
    }

    private static Tensor permute(Tensor tensor, int[] indicesArray, int[] upperPermutation, int[] lowerPermutation, List<int[]> generatedPermutations, List<Permutation> symmetries) {
        int[] permutation = new int[upperPermutation.length + lowerPermutation.length];
        System.arraycopy(upperPermutation, 0, permutation, 0, upperPermutation.length);
        System.arraycopy(lowerPermutation, 0, permutation, upperPermutation.length, lowerPermutation.length);
        for (int[] p : generatedPermutations) {
            for (Permutation symmetry : symmetries) {
                if (!Arrays.equals(permutation, symmetry.permute(p))) continue;
                return null;
            }
        }
        generatedPermutations.add(permutation);
        int[] newIndices = new int[indicesArray.length];
        for (int i = 0; i < indicesArray.length; ++i) {
            newIndices[i] = indicesArray[permutation[i]];
        }
        return ApplyIndexMapping.applyIndexMapping(tensor, new Mapping(indicesArray, newIndices), new int[0]);
    }

    static Tensor[] getAllPermutations(Tensor tensor) {
        return SymmetrizeUpperLowerIndicesTransformation.symmetrizeUpperLowerIndices(tensor).toArray();
    }
}

