/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.transformations.substitutions.PrimitiveSubstitution;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.transformations.substitutions.SumBijectionPort;
import java.util.Arrays;

class PrimitiveSumSubstitution
extends PrimitiveSubstitution {
    public PrimitiveSumSubstitution(Tensor from, Tensor to) {
        super(from, to);
    }

    @Override
    Tensor newTo_(Tensor current, SubstitutionIterator iterator) {
        Tensor old = null;
        while (old != current) {
            old = current;
            SumBijectionPort.BijectionContainer bc = new SumBijectionPort(this.from, current).take();
            if (bc == null) {
                return current;
            }
            Mapping mapping = bc.mapping;
            Tensor newTo = this.applyIndexMappingToTo(current, this.to, mapping, iterator);
            SumBuilder builder = new SumBuilder();
            int[] bijection = bc.bijection;
            builder.put(newTo);
            Arrays.sort(bijection);
            int pivot = 0;
            int size = current.size();
            for (int i = 0; i < size; ++i) {
                if (pivot >= bijection.length || i != bijection[pivot]) {
                    builder.put(current.get(i));
                    continue;
                }
                ++pivot;
            }
            current = builder.build();
        }
        return current;
    }
}

