/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.iterator.TIntIterator;

abstract class PrimitiveSubstitution {
    final Tensor from;
    final Tensor to;
    final boolean toIsSymbolic;
    final boolean possiblyAddsDummies;

    PrimitiveSubstitution(Tensor from, Tensor to) {
        this.from = ApplyIndexMapping.optimizeDummies(from);
        this.to = ApplyIndexMapping.optimizeDummies(to);
        int[] typesCounts = new int[8];
        TIntIterator iterator = TensorUtils.getAllDummyIndicesIncludingScalarFunctionsT(to).iterator();
        while (iterator.hasNext()) {
            byte by = IndicesUtils.getType(iterator.next());
            typesCounts[by] = typesCounts[by] + 1;
        }
        iterator = TensorUtils.getAllDummyIndicesT(from).iterator();
        while (iterator.hasNext()) {
            byte by = IndicesUtils.getType(iterator.next());
            typesCounts[by] = typesCounts[by] - 1;
        }
        boolean possiblyAddsDummies = false;
        for (int i : typesCounts) {
            if (i <= 0) continue;
            possiblyAddsDummies = true;
            break;
        }
        this.possiblyAddsDummies = possiblyAddsDummies;
        this.toIsSymbolic = TensorUtils.isSymbolic(to);
    }

    Tensor newTo(Tensor current, SubstitutionIterator iterator) {
        if (current.getClass() != this.from.getClass()) {
            return current;
        }
        return this.newTo_(current, iterator);
    }

    Tensor applyIndexMappingToTo(Tensor oldFrom, Tensor to, Mapping mapping, SubstitutionIterator iterator) {
        if (this.toIsSymbolic) {
            return mapping.getSign() ? Tensors.negate(to) : to;
        }
        if (this.possiblyAddsDummies) {
            return ApplyIndexMapping.applyIndexMapping(to, mapping, iterator.getForbidden());
        }
        return ApplyIndexMapping.applyIndexMappingAndRenameAllDummies(to, mapping, TensorUtils.getAllDummyIndicesT(oldFrom).toArray());
    }

    abstract Tensor newTo_(Tensor var1, SubstitutionIterator var2);
}

