/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.combinatorics.IntDistinctTuplesPort;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.OutputPort;

final class IndexlessBijectionsPort
implements OutputPort<int[]> {
    private boolean finished = false;
    private final IntDistinctTuplesPort combinationsPort;

    public IndexlessBijectionsPort(Tensor[] from, Tensor[] to) {
        int i;
        if (from.length > to.length) {
            this.finished = true;
            this.combinationsPort = null;
            return;
        }
        IntArrayList[] hashReflections = new IntArrayList[from.length];
        for (i = 0; i < from.length; ++i) {
            int j;
            hashReflections[i] = new IntArrayList();
            int hash = from[i].hashCode();
            for (j = 0; j < to.length && to[j].hashCode() < hash; ++j) {
            }
            if (j == to.length || to[j].hashCode() > hash) {
                this.finished = true;
                break;
            }
            while (j < to.length && to[j].hashCode() == hash) {
                hashReflections[i].add(j);
                ++j;
            }
        }
        if (this.finished) {
            this.combinationsPort = null;
            return;
        }
        int[][] r = new int[from.length][];
        for (i = 0; i < from.length; ++i) {
            r[i] = hashReflections[i].toArray();
        }
        this.combinationsPort = new IntDistinctTuplesPort(r);
    }

    @Override
    public int[] take() {
        if (this.finished) {
            return null;
        }
        return this.combinationsPort.take();
    }
}

