/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.powerexpand;

import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.Indicator;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;

public final class PowerExpandUtils {
    private PowerExpandUtils() {
    }

    public static boolean powerUnfoldApplicable(Tensor power, Indicator<Tensor> indicator) {
        return power instanceof Power && (power.get(0).getIndices().size() != 0 || power.get(0) instanceof Product && !TensorUtils.isInteger(power.get(1))) && PowerExpandUtils.powerExpandApplicable1(power, indicator);
    }

    public static boolean powerExpandApplicable(Tensor power, Indicator<Tensor> indicator) {
        return power instanceof Power && power.get(0) instanceof Product && !TensorUtils.isInteger(power.get(1)) && PowerExpandUtils.powerExpandApplicable1(power, indicator);
    }

    static boolean powerExpandApplicable1(Tensor power, Indicator<Tensor> indicator) {
        for (Tensor t : power.get(0)) {
            if (!indicator.is(t)) continue;
            return true;
        }
        return indicator.is(power);
    }

    public static Tensor[] powerExpandToArray(Power power) {
        return PowerExpandUtils.powerExpandToArray(power, Indicator.TRUE_INDICATOR);
    }

    static Indicator<Tensor> varsToIndicator(SimpleTensor[] vars) {
        final int[] names = new int[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            names[i] = vars[i].getName();
        }
        Arrays.sort(names);
        return new Indicator<Tensor>(){

            @Override
            public boolean is(Tensor object) {
                int toCheck;
                if (object instanceof SimpleTensor) {
                    toCheck = object.hashCode();
                } else if (object instanceof Power) {
                    if (!(object.get(0) instanceof SimpleTensor)) {
                        return false;
                    }
                    toCheck = object.get(0).hashCode();
                } else {
                    return false;
                }
                return Arrays.binarySearch(names, toCheck) >= 0;
            }
        };
    }

    public static Tensor[] powerExpandToArray(Power power, SimpleTensor[] vars) {
        return PowerExpandUtils.powerExpandToArray(power, PowerExpandUtils.varsToIndicator(vars));
    }

    public static Tensor[] powerExpandToArray(Power power, Indicator<Tensor> indicator) {
        if (!(power.get(0) instanceof Product)) {
            throw new IllegalArgumentException("Base should be product of tensors.");
        }
        return PowerExpandUtils.powerExpandToArray1(power, indicator);
    }

    static Tensor[] powerExpandToArray1(Tensor power, Indicator<Tensor> indicator) {
        Tensor[] scalars = ((Product)power.get(0)).getAllScalars();
        ArrayList<Tensor> factorOut = new ArrayList<Tensor>(scalars.length);
        ArrayList<Tensor> leave = new ArrayList<Tensor>(scalars.length);
        Tensor exponent = power.get(1);
        for (int i = 0; i < scalars.length; ++i) {
            if (indicator.is(scalars[i])) {
                factorOut.add(Tensors.pow(scalars[i], exponent));
                continue;
            }
            leave.add(scalars[i]);
        }
        if (!leave.isEmpty()) {
            factorOut.add(Tensors.pow(Tensors.multiply(leave.toArray(new Tensor[leave.size()])), exponent));
        }
        return factorOut.toArray(new Tensor[factorOut.size()]);
    }

    static Tensor[] powerExpandIntoChainToArray(Power power, int[] forbiddenIndices, Indicator<Tensor> indicator) {
        if (!(power.get(0) instanceof Product)) {
            throw new IllegalArgumentException("Base should be product of tensors.");
        }
        return PowerExpandUtils.powerExpandIntoChainToArray1(power, forbiddenIndices, indicator);
    }

    static Tensor[] powerExpandIntoChainToArray1(Tensor power, int[] forbiddenIndices, Indicator<Tensor> indicator) {
        if (!TensorUtils.isPositiveNaturalNumber(power.get(1))) {
            return PowerExpandUtils.powerExpandToArray1(power, indicator);
        }
        int exponent = ((Complex)power.get(1)).intValue();
        Tensor[] scalars = power.get(0) instanceof Product ? ((Product)power.get(0)).getAllScalars() : new Tensor[]{power.get(0)};
        ArrayList<Tensor> factorOut = new ArrayList<Tensor>(scalars.length);
        ArrayList<Tensor> leave = new ArrayList<Tensor>(scalars.length);
        TIntHashSet allForbidden = new TIntHashSet(forbiddenIndices);
        for (int i = 0; i < scalars.length; ++i) {
            if (indicator.is(scalars[i])) {
                if (scalars[i] instanceof SimpleTensor && scalars[i].getIndices().size() == 0) {
                    factorOut.add(Tensors.pow(scalars[i], exponent));
                    continue;
                }
                for (int j = 0; j < exponent; ++j) {
                    Tensor temp = ApplyIndexMapping.renameDummy(scalars[i], allForbidden.toArray());
                    allForbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(temp));
                    factorOut.add(temp);
                }
                continue;
            }
            leave.add(scalars[i]);
        }
        if (!leave.isEmpty()) {
            factorOut.add(Tensors.pow(Tensors.multiply(leave.toArray(new Tensor[leave.size()])), exponent));
        }
        return factorOut.toArray(new Tensor[factorOut.size()]);
    }
}

