/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Monomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Quotient;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.QuotientRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFieldCharP;
import java.math.BigInteger;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SquarefreeInfiniteFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<Quotient<C>> {
    protected final SquarefreeAbstract<C> qengine;

    public SquarefreeInfiniteFieldCharP(RingFactory<Quotient<C>> fac) {
        super(fac);
        if (fac.isFinite()) {
            throw new IllegalArgumentException("fac must be in-finite");
        }
        QuotientRing qfac = (QuotientRing)fac;
        GenPolynomialRing rfac = qfac.ring;
        this.qengine = SquarefreeFactory.getImplementation(rfac);
    }

    @Override
    public SortedMap<Quotient<C>, Long> squarefreeFactors(Quotient<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap<Quotient<C>, Long> factors = new TreeMap<Quotient<C>, Long>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.put(P, 1L);
            return factors;
        }
        GenPolynomial num = P.num;
        GenPolynomial den = P.den;
        QuotientRing pfac = P.ring;
        MonoidElem one = pfac.ring.getONE();
        if (!num.isONE()) {
            SortedMap nfac = this.qengine.squarefreeFactors(num);
            for (Map.Entry me : nfac.entrySet()) {
                GenPolynomial nfp = me.getKey();
                Quotient nf = new Quotient(pfac, nfp);
                factors.put(nf, me.getValue());
            }
        }
        if (den.isONE()) {
            if (factors.size() == 0) {
                factors.put(P, 1L);
            }
            return factors;
        }
        SortedMap dfac = this.qengine.squarefreeFactors(den);
        for (Map.Entry me : dfac.entrySet()) {
            GenPolynomial dfp = me.getKey();
            Quotient df = new Quotient(pfac, one, dfp);
            factors.put(df, me.getValue());
        }
        if (factors.size() == 0) {
            factors.put(P, 1L);
        }
        return factors;
    }

    public SortedMap<Quotient<C>, Long> rootCharacteristic(Quotient<C> P) {
        Long e;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger c = P.ring.characteristic();
        if (c.signum() == 0) {
            return null;
        }
        TreeMap<Quotient<C>, Long> root = new TreeMap<Quotient<C>, Long>();
        if (P.isZERO()) {
            return root;
        }
        if (P.isONE()) {
            root.put(P, 1L);
            return root;
        }
        SortedMap<Quotient<C>, Long> sf = this.squarefreeFactors(P);
        if (sf.size() == 0) {
            return null;
        }
        Long k = null;
        Long cl = c.longValue();
        for (Map.Entry<Quotient<C>, Long> me : sf.entrySet()) {
            Quotient<C> p = me.getKey();
            if (p.isConstant()) continue;
            e = me.getValue();
            long E = e;
            long r = E % cl;
            if (r != 0L) {
                return null;
            }
            if (k == null) {
                k = e;
                continue;
            }
            if (k < e) continue;
            k = e;
        }
        if (k == null) {
            k = 1L;
        }
        for (Map.Entry<Quotient<C>, Long> me : sf.entrySet()) {
            Quotient<C> q = me.getKey();
            e = me.getValue();
            if (e >= k) {
                e = e / cl;
                root.put(q, e);
                continue;
            }
            root.put(q, e);
        }
        return root;
    }

    public GenPolynomial<Quotient<C>> rootCharacteristic(GenPolynomial<Quotient<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            GenPolynomialRing cfac = pfac.contract(1);
            GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
            GenPolynomial<GenPolynomial<Quotient<C>>> Pr = PolyUtil.recursive(rfac, P);
            GenPolynomial Prc = this.recursiveUnivariateRootCharacteristic(Pr);
            if (Prc == null) {
                return null;
            }
            GenPolynomial<Quotient<C>> D = PolyUtil.distribute(pfac, Prc);
            return D;
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for ModInteger polynomials " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<Quotient<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<Quotient<C>, Long> sm = this.rootCharacteristic((Quotient)monomial.c);
            if (sm == null) {
                return null;
            }
            Quotient<Quotient<Quotient<C>>> r = (Quotient<Quotient<Quotient<C>>>)rf.getONE();
            for (Map.Entry<Quotient<C>, Long> me : sm.entrySet()) {
                Quotient<C> rp = me.getKey();
                long gl = me.getValue();
                if (gl > 1L) {
                    rp = Power.positivePower(rp, gl);
                }
                r = r.multiply((Quotient<Quotient<C>>)rp);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }

    @Override
    public GenPolynomial<Quotient<C>> baseRootCharacteristic(GenPolynomial<Quotient<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<Quotient<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<Quotient<C>, Long> sm = this.rootCharacteristic((Quotient)monomial.c);
            if (sm == null) {
                return null;
            }
            Quotient<Quotient<Quotient<C>>> r = (Quotient<Quotient<Quotient<C>>>)rf.getONE();
            for (Map.Entry<Quotient<C>, Long> me : sm.entrySet()) {
                Quotient<C> rp = me.getKey();
                long gl = me.getValue();
                Quotient<C> re = rp;
                if (gl > 1L) {
                    re = Power.positivePower(rp, gl);
                }
                r = r.multiply((Quotient<Quotient<C>>)re);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }

    @Override
    public GenPolynomial<GenPolynomial<Quotient<C>>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<Quotient<C>>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate recursive polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<GenPolynomial<Quotient<C>>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            GenPolynomial<Quotient<C>> r = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (r == null) {
                return null;
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }
}

