/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.gb.GroebnerBase;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.gb.ReductionSeq;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Monomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Quotient;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFieldCharP;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SquarefreeInfiniteAlgebraicFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<AlgebraicNumber<C>> {
    protected final SquarefreeAbstract<C> aengine;

    public SquarefreeInfiniteAlgebraicFieldCharP(RingFactory<AlgebraicNumber<C>> fac) {
        super(fac);
        if (fac.isFinite()) {
            throw new IllegalArgumentException("fac must be in-finite");
        }
        AlgebraicNumberRing afac = (AlgebraicNumberRing)fac;
        GenPolynomialRing rfac = afac.ring;
        this.aengine = SquarefreeFactory.getImplementation(rfac);
    }

    @Override
    public SortedMap<AlgebraicNumber<C>, Long> squarefreeFactors(AlgebraicNumber<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap<AlgebraicNumber<C>, Long> factors = new TreeMap<AlgebraicNumber<C>, Long>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.put(P, 1L);
            return factors;
        }
        GenPolynomial an = P.val;
        AlgebraicNumberRing pfac = P.ring;
        if (!an.isONE()) {
            SortedMap nfac = this.aengine.squarefreeFactors(an);
            for (Map.Entry me : nfac.entrySet()) {
                GenPolynomial nfp = me.getKey();
                AlgebraicNumber nf = new AlgebraicNumber(pfac, nfp);
                factors.put(nf, me.getValue());
            }
        }
        if (factors.size() == 0) {
            factors.put(P, 1L);
        }
        return factors;
    }

    public SortedMap<AlgebraicNumber<C>, Long> rootCharacteristic(AlgebraicNumber<C> P) {
        ReductionSeq red;
        GroebnerBase bb;
        int z;
        GcdRingElem pc;
        GcdRingElem cc;
        ExpVector e;
        Monomial ma;
        Object ap;
        AlgebraicNumber a;
        ExpVector f;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger c = P.ring.characteristic();
        if (c.signum() == 0) {
            return null;
        }
        TreeMap<AlgebraicNumber<C>, Long> root = new TreeMap<AlgebraicNumber<C>, Long>();
        if (P.isZERO()) {
            return root;
        }
        if (P.isONE()) {
            root.put(P, 1L);
            return root;
        }
        AlgebraicNumberRing afac = P.ring;
        long deg = afac.modul.degree(0);
        int d = (int)deg;
        String[] vn = GenPolynomialRing.newVars("c", d);
        GenPolynomialRing pfac = new GenPolynomialRing(afac, d, vn);
        List uv = pfac.univariateList();
        GenPolynomial cp = pfac.getZERO();
        GenPolynomialRing apfac = afac.ring;
        long i = 0L;
        for (GenPolynomial genPolynomial : uv) {
            GenPolynomial ca = apfac.univariate(0, i++);
            Iterator pb = genPolynomial.multiply(new AlgebraicNumber(afac, ca));
            cp = cp.sum(pb);
        }
        GenPolynomial cpp = (GenPolynomial)Power.positivePower(cp, c);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(apfac.coFac, pfac);
        List gl = new ArrayList();
        if (deg == c.longValue() && afac.modul.length() == 2) {
            for (Monomial m : cpp) {
                f = m.e;
                a = (AlgebraicNumber)m.c;
                ap = a.val;
                Iterator iterator = ((GenPolynomial)ap).iterator();
                while (iterator.hasNext()) {
                    ma = iterator.next();
                    e = ma.e;
                    cc = (GcdRingElem)ma.c;
                    pc = (GcdRingElem)P.val.coefficient(e);
                    GcdRingElem cc1 = (GcdRingElem)((RingFactory)pc.factory()).getONE();
                    GcdRingElem pc1 = (GcdRingElem)((RingFactory)pc.factory()).getZERO();
                    if (cc instanceof AlgebraicNumber && pc instanceof AlgebraicNumber) {
                        throw new UnsupportedOperationException("case multiple algebraic extensions not implemented");
                    }
                    if (!(cc instanceof Quotient) || !(pc instanceof Quotient)) continue;
                    Quotient ccp = (Quotient)cc;
                    Quotient pcp = (Quotient)pc;
                    if (pcp.isConstant()) {
                        throw new ArithmeticException("finite field not allowed here ");
                    }
                    Quotient dcp = ccp.divide(pcp);
                    if (dcp.isConstant()) {
                        cc1 = cc;
                        pc1 = pc;
                    }
                    GenPolynomial<GcdRingElem> r = new GenPolynomial<GcdRingElem>(genPolynomialRing, cc1, f);
                    r = r.subtract(pc1);
                    gl.add(r);
                }
            }
        } else {
            for (Monomial m : cpp) {
                f = m.e;
                a = (AlgebraicNumber)m.c;
                ap = a.val;
                Iterator iterator = ((GenPolynomial)ap).iterator();
                while (iterator.hasNext()) {
                    ma = iterator.next();
                    e = ma.e;
                    cc = (GcdRingElem)ma.c;
                    pc = (GcdRingElem)P.val.coefficient(e);
                    GenPolynomial<GcdRingElem> r = new GenPolynomial<GcdRingElem>(genPolynomialRing, cc, f);
                    r = r.subtract(pc);
                    gl.add(r);
                }
            }
        }
        if ((z = (bb = new GroebnerBase()).commonZeroTest(gl = (red = new ReductionSeq()).irreducibleSet(gl))) < 0) {
            return null;
        }
        GenPolynomial car = apfac.getZERO();
        for (GenPolynomial genPolynomial : gl) {
            SortedMap<GcdRingElem, Long> br;
            if (genPolynomial.length() <= 1) continue;
            if (genPolynomial.length() > 2) {
                throw new IllegalArgumentException("dim > 0 not implemented " + genPolynomial);
            }
            ExpVector e2 = genPolynomial.leadingExpVector();
            int[] v = e2.dependencyOnVariables();
            if (v == null || v.length == 0) continue;
            int vi = v[0];
            GenPolynomial<GcdRingElem> ca = apfac.univariate(0, deg - 1L - (long)vi);
            GcdRingElem tc = (GcdRingElem)genPolynomial.trailingBaseCoefficient();
            tc = (GcdRingElem)tc.negate();
            if (e2.maxDeg() == c.longValue() && (br = this.aengine.squarefreeFactors(tc)) != null && br.size() > 0) {
                GcdRingElem cc2 = (GcdRingElem)apfac.coFac.getONE();
                for (Map.Entry<GcdRingElem, Long> me : br.entrySet()) {
                    GcdRingElem bc = me.getKey();
                    long ll = me.getValue();
                    if (ll % c.longValue() == 0L) {
                        long fl = ll / c.longValue();
                        cc2 = cc2.multiply(Power.positivePower(bc, fl));
                        continue;
                    }
                    cc2 = cc2.multiply(bc);
                }
                tc = cc2;
            }
            ca = ca.multiply(tc);
            car = car.sum(ca);
        }
        AlgebraicNumber rr = new AlgebraicNumber(afac, car);
        root.put(rr, 1L);
        return root;
    }

    public GenPolynomial<AlgebraicNumber<C>> rootCharacteristic(GenPolynomial<AlgebraicNumber<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            GenPolynomialRing cfac = pfac.contract(1);
            GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> Pr = PolyUtil.recursive(rfac, P);
            GenPolynomial Prc = this.recursiveUnivariateRootCharacteristic(Pr);
            if (Prc == null) {
                return null;
            }
            GenPolynomial<AlgebraicNumber<C>> D = PolyUtil.distribute(pfac, Prc);
            return D;
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for ModInteger polynomials " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<AlgebraicNumber<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<AlgebraicNumber<C>, Long> sm = this.rootCharacteristic((AlgebraicNumber)monomial.c);
            if (sm == null) {
                return null;
            }
            AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>> r = (AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>>)rf.getONE();
            for (Map.Entry<AlgebraicNumber<C>, Long> me : sm.entrySet()) {
                AlgebraicNumber<C> rp = me.getKey();
                long gl = me.getValue();
                if (gl > 1L) {
                    rp = Power.positivePower(rp, gl);
                }
                r = r.multiply((AlgebraicNumber<AlgebraicNumber<C>>)rp);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }

    @Override
    public GenPolynomial<AlgebraicNumber<C>> baseRootCharacteristic(GenPolynomial<AlgebraicNumber<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<AlgebraicNumber<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<AlgebraicNumber<C>, Long> sm = this.rootCharacteristic((AlgebraicNumber)monomial.c);
            if (sm == null) {
                return null;
            }
            AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>> r = (AlgebraicNumber<AlgebraicNumber<AlgebraicNumber<C>>>)rf.getONE();
            for (Map.Entry<AlgebraicNumber<C>, Long> me : sm.entrySet()) {
                AlgebraicNumber<C> rp = me.getKey();
                long gl = me.getValue();
                AlgebraicNumber<C> re = rp;
                if (gl > 1L) {
                    re = Power.positivePower(rp, gl);
                }
                r = r.multiply((AlgebraicNumber<AlgebraicNumber<C>>)re);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }

    @Override
    public GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate recursive polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<GenPolynomial<AlgebraicNumber<C>>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            GenPolynomial<AlgebraicNumber<C>> r = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (r == null) {
                return null;
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }
}

