/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLong;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLongRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.PolyUfdUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Quotient;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.QuotientRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFieldChar0;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFieldCharP;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFiniteFieldCharP;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeRingChar0;

public class SquarefreeFactory {
    protected SquarefreeFactory() {
    }

    public static SquarefreeAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        return new SquarefreeFiniteFieldCharP<ModInteger>(fac);
    }

    public static SquarefreeAbstract<ModLong> getImplementation(ModLongRing fac) {
        return new SquarefreeFiniteFieldCharP<ModLong>(fac);
    }

    public static SquarefreeAbstract<BigInteger> getImplementation(BigInteger fac) {
        return new SquarefreeRingChar0<BigInteger>(fac);
    }

    public static SquarefreeAbstract<BigRational> getImplementation(BigRational fac) {
        return new SquarefreeFieldChar0<BigRational>(fac);
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> fac) {
        PolyUfdUtil.ensureFieldProperty(fac);
        if (fac.isField()) {
            if (fac.characteristic().signum() == 0) {
                return new SquarefreeFieldChar0<AlgebraicNumber<C>>(fac);
            }
            if (fac.isFinite()) {
                return new SquarefreeFiniteFieldCharP<AlgebraicNumber<C>>(fac);
            }
            return new SquarefreeInfiniteAlgebraicFieldCharP(fac);
        }
        throw new ArithmeticException("eventually no integral domain " + fac.getClass().getName());
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac) {
        if (fac.characteristic().signum() == 0) {
            return new SquarefreeFieldChar0<Quotient<C>>(fac);
        }
        return new SquarefreeInfiniteFieldCharP(fac);
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementation(GenPolynomialRing<C> fac) {
        return SquarefreeFactory.getImplementationPoly(fac);
    }

    protected static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementationPoly(GenPolynomialRing<C> fac) {
        if (fac.characteristic().signum() == 0) {
            if (fac.coFac.isField()) {
                return new SquarefreeFieldChar0(fac.coFac);
            }
            return new SquarefreeRingChar0(fac.coFac);
        }
        if (fac.coFac.isFinite()) {
            return new SquarefreeFiniteFieldCharP(fac.coFac);
        }
        RingFactory ocfac = fac.coFac;
        SquarefreeFieldCharP saq = null;
        if (ocfac instanceof QuotientRing) {
            QuotientRing qf = (QuotientRing)ocfac;
            saq = new SquarefreeInfiniteFieldCharP(qf);
        } else if (ocfac instanceof AlgebraicNumberRing) {
            AlgebraicNumberRing af = (AlgebraicNumberRing)ocfac;
            saq = new SquarefreeInfiniteAlgebraicFieldCharP(af);
        }
        if (saq == null) {
            throw new IllegalArgumentException("no squarefree factorization " + fac.coFac);
        }
        SquarefreeInfiniteFieldCharP sa = saq;
        return sa;
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementation(RingFactory<C> fac) {
        SquarefreeAbstract ufd = null;
        AlgebraicNumberRing afac = null;
        QuotientRing qfac = null;
        GenPolynomialRing pfac = null;
        RingFactory ofac = fac;
        if (ofac instanceof BigInteger) {
            ufd = new SquarefreeRingChar0<C>(fac);
        } else if (ofac instanceof BigRational) {
            ufd = new SquarefreeFieldChar0<C>(fac);
        } else if (ofac instanceof ModIntegerRing) {
            ufd = new SquarefreeFiniteFieldCharP<C>(fac);
        } else if (ofac instanceof ModLongRing) {
            ufd = new SquarefreeFiniteFieldCharP<C>(fac);
        } else if (ofac instanceof AlgebraicNumberRing) {
            afac = (AlgebraicNumberRing)ofac;
            ufd = SquarefreeFactory.getImplementation(afac);
        } else if (ofac instanceof QuotientRing) {
            qfac = (QuotientRing)ofac;
            ufd = SquarefreeFactory.getImplementation(qfac);
        } else if (ofac instanceof GenPolynomialRing) {
            pfac = (GenPolynomialRing)ofac;
            ufd = SquarefreeFactory.getImplementationPoly(pfac);
        } else if (fac.isField()) {
            ufd = fac.characteristic().signum() == 0 ? new SquarefreeFieldChar0<C>(fac) : (fac.isFinite() ? new SquarefreeFiniteFieldCharP<C>(fac) : new SquarefreeInfiniteFieldCharP(fac));
        } else if (fac.characteristic().signum() == 0) {
            ufd = new SquarefreeRingChar0<C>(fac);
        } else {
            throw new IllegalArgumentException("no squarefree factorization implementation for " + fac.getClass().getName());
        }
        return ufd;
    }
}

