/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorAbstract;

public class GreatestCommonDivisorSubres<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    @Override
    public GenPolynomial<C> baseGcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        AbelianGroupElem<GenPolynomial<C>> q;
        AbelianGroupElem<GenPolynomial<C>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        C a = this.baseContent(r);
        C b = this.baseContent(q);
        C c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<C>)c);
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<C>)c);
        }
        GcdRingElem g = (GcdRingElem)((GenPolynomial)r).ring.getONECoefficient();
        GcdRingElem h = (GcdRingElem)((GenPolynomial)r).ring.getONECoefficient();
        while (!((GenPolynomial)r).isZERO()) {
            long delta = ((GenPolynomial)q).degree(0) - ((GenPolynomial)r).degree(0);
            GenPolynomial<GenPolynomial<GcdRingElem>> x = PolyUtil.baseDensePseudoRemainder(q, r);
            q = r;
            if (!x.isZERO()) {
                GcdRingElem z = g.multiply(this.power(P.ring.coFac, h, delta));
                r = x.divide((GenPolynomial<GcdRingElem>)((Object)z));
                g = (GcdRingElem)((GenPolynomial)q).leadingBaseCoefficient();
                z = this.power(P.ring.coFac, g, delta);
                h = z.divide(this.power(P.ring.coFac, h, delta - 1L));
                continue;
            }
            r = x;
        }
        q = this.basePrimitivePart(q);
        return ((GenPolynomial)q).multiply((GenPolynomial<C>)c).abs();
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        AbelianGroupElem<GenPolynomial<Object>> q;
        AbelianGroupElem<GenPolynomial<Object>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        GenPolynomial<C> a = this.recursiveContent(r);
        GenPolynomial<C> b = this.recursiveContent(q);
        GenPolynomial<C> c = this.gcd(a, b);
        r = PolyUtil.recursiveDivide(r, a);
        q = PolyUtil.recursiveDivide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply(c);
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply(c);
        }
        GenPolynomial g = (GenPolynomial)((GenPolynomial)r).ring.getONECoefficient();
        GenPolynomial<GenPolynomial<C>> h = (GenPolynomial<GenPolynomial<C>>)((GenPolynomial)r).ring.getONECoefficient();
        GenPolynomial<GenPolynomial<C>> z = null;
        while (!((GenPolynomial)r).isZERO()) {
            long delta = ((GenPolynomial)q).degree(0) - ((GenPolynomial)r).degree(0);
            GenPolynomial x = PolyUtil.recursiveDensePseudoRemainder(q, r);
            q = r;
            if (!x.isZERO()) {
                z = g.multiply(this.power(P.ring.coFac, h, delta));
                r = PolyUtil.recursiveDivide(x, z);
                g = (GenPolynomial)((GenPolynomial)q).leadingBaseCoefficient();
                z = this.power(P.ring.coFac, g, delta);
                h = PolyUtil.basePseudoDivide(z, this.power(P.ring.coFac, h, delta - 1L));
                continue;
            }
            r = x;
        }
        q = this.recursivePrimitivePart(q);
        return ((GenPolynomial)((GenPolynomial)q).abs()).multiply(c);
    }

    @Override
    public GenPolynomial<C> baseResultant(GenPolynomial<C> P, GenPolynomial<C> S) {
        GcdRingElem z;
        GenPolynomial<GcdRingElem> x;
        GenPolynomial<C> q;
        GenPolynomial<Object> r;
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        C a = this.baseContent(r);
        C b = this.baseContent(q);
        r = this.divide(r, a);
        q = this.divide(q, b);
        RingFactory cofac = P.ring.coFac;
        GcdRingElem g = (GcdRingElem)cofac.getONE();
        GcdRingElem h = (GcdRingElem)cofac.getONE();
        Object t = this.power(cofac, a, e);
        t = (GcdRingElem)t.multiply(this.power(cofac, b, f));
        long s = 1L;
        while (r.degree(0) > 0L) {
            long delta = q.degree(0) - r.degree(0);
            if (q.degree(0) % 2L != 0L && r.degree(0) % 2L != 0L) {
                s = -s;
            }
            x = PolyUtil.baseDensePseudoRemainder(q, r);
            q = r;
            if (x.degree(0) > 0L) {
                z = g.multiply(this.power(cofac, h, delta));
                r = x.divide(z);
                g = (GcdRingElem)q.leadingBaseCoefficient();
                z = this.power(cofac, g, delta);
                h = z.divide(this.power(cofac, h, delta - 1L));
                continue;
            }
            r = x;
        }
        z = this.power(cofac, (GcdRingElem)r.leadingBaseCoefficient(), q.degree(0));
        h = z.divide(this.power(cofac, h, q.degree(0) - 1L));
        z = (GcdRingElem)h.multiply(t);
        if (s < 0L) {
            z = (GcdRingElem)z.negate();
        }
        x = ((GenPolynomial)P.ring.getONE()).multiply(z);
        return x;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateResultant(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        AbelianGroupElem<GenPolynomial<C>> z;
        GenPolynomial<GenPolynomial<C>> x;
        AbelianGroupElem<GenPolynomial<Object>> q;
        AbelianGroupElem<GenPolynomial<Object>> r;
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        GenPolynomial<C> a = this.recursiveContent(r);
        GenPolynomial<C> b = this.recursiveContent(q);
        r = PolyUtil.recursiveDivide(r, a);
        q = PolyUtil.recursiveDivide(q, b);
        RingFactory<GenPolynomial<C>> cofac = P.ring.coFac;
        GenPolynomial g = (GenPolynomial)cofac.getONE();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> h = (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)cofac.getONE();
        if (f == 0L && e == 0L && g.ring.nvar > 0) {
            GenPolynomial<C> t = this.resultant(a, b);
            GenPolynomial<GenPolynomial<C>> x2 = ((GenPolynomial)P.ring.getONE()).multiply(t);
            return x2;
        }
        GenPolynomial<GenPolynomial<C>> t = this.power(cofac, a, e);
        t = t.multiply(this.power(cofac, b, f));
        long s = 1L;
        while (((GenPolynomial)r).degree(0) > 0L) {
            long delta = ((GenPolynomial)q).degree(0) - ((GenPolynomial)r).degree(0);
            if (((GenPolynomial)q).degree(0) % 2L != 0L && ((GenPolynomial)r).degree(0) % 2L != 0L) {
                s = -s;
            }
            x = PolyUtil.recursiveDensePseudoRemainder(q, r);
            q = r;
            if (x.degree(0) > 0L) {
                z = g.multiply(this.power(P.ring.coFac, h, delta));
                r = PolyUtil.recursiveDivide(x, z);
                g = (GenPolynomial)((GenPolynomial)q).leadingBaseCoefficient();
                z = this.power(cofac, g, delta);
                h = PolyUtil.basePseudoDivide(z, this.power(cofac, h, delta - 1L));
                continue;
            }
            r = x;
        }
        z = this.power(cofac, (GenPolynomial)((GenPolynomial)r).leadingBaseCoefficient(), ((GenPolynomial)q).degree(0));
        h = PolyUtil.basePseudoDivide(z, this.power(cofac, h, ((GenPolynomial)q).degree(0) - 1L));
        z = h.multiply(t);
        if (s < 0L) {
            z = z.negate();
        }
        x = ((GenPolynomial)P.ring.getONE()).multiply(z);
        return x;
    }

    C power(RingFactory<C> fac, C A, long i) {
        return (C)((GcdRingElem)Power.power(fac, A, i));
    }

    GenPolynomial<C> power(RingFactory<GenPolynomial<C>> fac, GenPolynomial<C> A, long i) {
        return Power.power(fac, A, i);
    }
}

