/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisor;
import java.util.ArrayList;
import java.util.List;

public abstract class GreatestCommonDivisorAbstract<C extends GcdRingElem<C>>
implements GreatestCommonDivisor<C> {
    public String toString() {
        return this.getClass().getName();
    }

    public C baseContent(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return (C)((GcdRingElem)P.ring.getZEROCoefficient());
        }
        AbelianGroupElem d = null;
        for (GcdRingElem c : P.getMap().values()) {
            if (!(d = d == null ? c : d.gcd(c)).isONE()) continue;
            return (C)d;
        }
        if (d.signum() < 0) {
            d = (GcdRingElem)d.negate();
        }
        return (C)d;
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        C d = this.baseContent(P);
        if (d.isONE()) {
            return P;
        }
        GenPolynomial<C> pp = P.divide(d);
        return pp;
    }

    public abstract GenPolynomial<C> baseGcd(GenPolynomial<C> var1, GenPolynomial<C> var2);

    public GenPolynomial<C> recursiveContent(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return (GenPolynomial)P.ring.getZEROCoefficient();
        }
        GenPolynomial<C> d = null;
        for (GenPolynomial<C> c : P.getMap().values()) {
            if (!(d = d == null ? c : this.gcd(d, c)).isONE()) continue;
            return d;
        }
        return d.abs();
    }

    public GenPolynomial<GenPolynomial<C>> recursivePrimitivePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomial<C> d = this.recursiveContent(P);
        if (d.isONE()) {
            return P;
        }
        GenPolynomial<GenPolynomial<C>> pp = PolyUtil.recursiveDivide(P, d);
        return pp;
    }

    public C baseRecursiveContent(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            GenPolynomialRing cf = (GenPolynomialRing)P.ring.coFac;
            return (C)((GcdRingElem)cf.coFac.getZERO());
        }
        AbelianGroupElem d = null;
        for (GenPolynomial<C> c : P.getMap().values()) {
            C cc = this.baseContent(c);
            if (!(d = d == null ? cc : this.gcd(d, cc)).isONE()) continue;
            return (C)d;
        }
        if (d.signum() < 0) {
            d = (GcdRingElem)d.negate();
        }
        return (C)d;
    }

    public GenPolynomial<GenPolynomial<C>> baseRecursivePrimitivePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        C d = this.baseRecursiveContent(P);
        if (d.isONE()) {
            return P;
        }
        GenPolynomial<GenPolynomial<C>> pp = PolyUtil.baseRecursiveDivide(P, d);
        return pp;
    }

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> var1, GenPolynomial<GenPolynomial<C>> var2);

    @Override
    public GenPolynomial<C> content(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " use baseContent for univariate polynomials");
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial D = this.recursiveContent(Pr);
        return D;
    }

    public GenPolynomial<C> divide(GenPolynomial<C> a, C b) {
        if (b == null || b.isZERO()) {
            throw new IllegalArgumentException("division by zero");
        }
        if (a == null || a.isZERO()) {
            return a;
        }
        return a.divide(b);
    }

    public C gcd(C a, C b) {
        if (b == null || b.isZERO()) {
            return a;
        }
        if (a == null || a.isZERO()) {
            return b;
        }
        return (C)((GcdRingElem)a.gcd(b));
    }

    @Override
    public GenPolynomial<C> gcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        GenPolynomialRing rfac;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            GenPolynomial<C> T = this.baseGcd(P, S);
            return T;
        }
        GenPolynomialRing cfac = pfac.contract(1);
        if (pfac.getVars() != null && pfac.getVars().length > 0) {
            String[] v = new String[]{pfac.getVars()[pfac.nvar - 1]};
            rfac = new GenPolynomialRing(cfac, 1, v);
        } else {
            rfac = new GenPolynomialRing(cfac, 1);
        }
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Sr = PolyUtil.recursive(rfac, S);
        GenPolynomial Dr = this.recursiveUnivariateGcd(Pr, Sr);
        GenPolynomial D = PolyUtil.distribute(pfac, Dr);
        return D;
    }

    @Override
    public GenPolynomial<C> lcm(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomial<C> C = this.gcd(P, S);
        GenPolynomial<GenPolynomial<C>> A = P.multiply(S);
        return PolyUtil.basePseudoDivide(A, C);
    }

    public GenPolynomial<C> gcd(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            throw new IllegalArgumentException("A may not be empty");
        }
        GenPolynomial<C> g = A.get(0);
        for (int i = 1; i < A.size(); ++i) {
            GenPolynomial<C> f = A.get(i);
            g = this.gcd(g, f);
        }
        return g;
    }

    public GenPolynomial<C> baseResultant(GenPolynomial<C> P, GenPolynomial<C> S) {
        throw new UnsupportedOperationException("not implmented");
    }

    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateResultant(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        throw new UnsupportedOperationException("not implmented");
    }

    public GenPolynomial<GenPolynomial<C>> recursiveResultant(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing rfac = P.ring;
        GenPolynomialRing cfac = (GenPolynomialRing)rfac.coFac;
        GenPolynomialRing dfac = cfac.extend(rfac.getVars());
        GenPolynomial Pp = PolyUtil.distribute(dfac, P);
        GenPolynomial Sp = PolyUtil.distribute(dfac, S);
        GenPolynomial res = this.resultant(Pp, Sp);
        GenPolynomial Rr = PolyUtil.recursive(rfac, res);
        return Rr;
    }

    @Override
    public GenPolynomial<C> resultant(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseResultant(P, S);
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Sr = PolyUtil.recursive(rfac, S);
        GenPolynomial Dr = this.recursiveUnivariateResultant(Pr, Sr);
        GenPolynomial D = PolyUtil.distribute(pfac, Dr);
        return D;
    }

    @Override
    public List<GenPolynomial<C>> coPrime(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        List<GenPolynomial<C>> B = new ArrayList<GenPolynomial<C>>(A.size());
        AbelianGroupElem<GenPolynomial<C>> a = A.get(0);
        if (!a.isZERO() && !a.isConstant()) {
            for (int i = 1; i < A.size(); ++i) {
                GenPolynomial<C> b = A.get(i);
                AbelianGroupElem g = this.gcd((GenPolynomial<C>)a, b).abs();
                if (!g.isONE()) {
                    a = PolyUtil.basePseudoDivide(a, g);
                    b = PolyUtil.basePseudoDivide(b, g);
                    AbelianGroupElem gp = this.gcd((GenPolynomial<C>)a, (GenPolynomial<C>)g).abs();
                    while (!((GenPolynomial)gp).isONE()) {
                        a = PolyUtil.basePseudoDivide(a, gp);
                        g = PolyUtil.basePseudoDivide(g, gp);
                        B.add((GenPolynomial<C>)g);
                        g = gp;
                        gp = this.gcd((GenPolynomial<C>)a, (GenPolynomial<C>)gp).abs();
                    }
                    if (!g.isZERO() && !g.isConstant()) {
                        B.add((GenPolynomial<C>)g);
                    }
                }
                if (b.isZERO() || b.isConstant()) continue;
                B.add(b);
            }
        } else {
            B.addAll(A.subList(1, A.size()));
        }
        B = this.coPrime(B);
        if (!a.isZERO() && !a.isConstant()) {
            a = a.abs();
            B.add((GenPolynomial<C>)a);
        }
        return B;
    }
}

