/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.Modular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularRingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbsolute;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class FactorModular<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbsolute<MOD> {
    public FactorModular(RingFactory<MOD> cfac) {
        super(cfac);
    }

    public SortedMap<Long, GenPolynomial<MOD>> baseDistinctDegreeFactors(GenPolynomial<MOD> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        TreeMap<Long, GenPolynomial<MOD>> facs = new TreeMap<Long, GenPolynomial<MOD>>();
        if (P.isZERO()) {
            return facs;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        ModularRingFactory mr = (ModularRingFactory)pfac.coFac;
        BigInteger m = mr.getIntegerModul().getVal();
        GenPolynomial x = pfac.univariate(0);
        GenPolynomial<Object> h = x;
        GenPolynomial<Object> f = P;
        Power<GenPolynomial<MOD>> pow = new Power<GenPolynomial<MOD>>(pfac);
        long d = 0L;
        while (d + 1L <= f.degree(0) / 2L) {
            ++d;
            GenPolynomial g = this.engine.gcd((h = pow.modPower(h, m, f)).subtract((Object)x), f);
            if (g.isONE()) continue;
            facs.put(d, g);
            f = f.divide(g);
        }
        if (!f.isONE()) {
            d = f.degree(0);
            facs.put(d, f);
        }
        return facs;
    }

    public List<GenPolynomial<MOD>> baseEqualDegreeFactors(GenPolynomial<MOD> P, long deg) {
        GenPolynomial<Object> h;
        GenPolynomial<Object> g;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        ArrayList<GenPolynomial<MOD>> facs = new ArrayList<GenPolynomial<MOD>>();
        if (P.isZERO()) {
            return facs;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (P.degree(0) == deg) {
            facs.add(P);
            return facs;
        }
        ModularRingFactory mr = (ModularRingFactory)pfac.coFac;
        BigInteger m = mr.getIntegerModul().getVal();
        boolean p2 = false;
        if (m.equals(BigInteger.valueOf(2L))) {
            p2 = true;
        }
        MonoidElem one = pfac.getONE();
        GenPolynomial t = pfac.univariate(0, 1L);
        GenPolynomial<Object> f = P;
        Power<GenPolynomial<MOD>> pow = new Power<GenPolynomial<MOD>>(pfac);
        int degi = (int)deg;
        cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger di = Power.positivePower(new cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger(m), deg);
        BigInteger d = di.getVal();
        d = d.shiftRight(1);
        do {
            if (p2) {
                h = t;
                for (int i = 1; i < degi; ++i) {
                    h = t.sum(h.multiply((Object)h));
                    h = h.remainder(f);
                }
                t = t.multiply(pfac.univariate(0, 2L));
                continue;
            }
            GenPolynomial<MOD> r = pfac.random(17, degi, 2 * degi, 1.0f);
            if (r.degree(0) >= f.degree(0)) {
                r = r.remainder(f);
            }
            r = r.monic();
            h = pow.modPower(r, d, f).subtract(one);
            ++degi;
        } while ((g = this.engine.gcd(h, f)).degree(0) == 0L || g.degree(0) == f.degree(0));
        f = f.divide(g);
        facs.addAll(this.baseEqualDegreeFactors(f, deg));
        facs.addAll(this.baseEqualDegreeFactors(g, deg));
        return facs;
    }

    @Override
    public List<GenPolynomial<MOD>> baseFactorsSquarefree(GenPolynomial<MOD> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        List<GenPolynomial<MOD>> factors = new ArrayList();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (!((GcdRingElem)P.leadingBaseCoefficient()).isONE()) {
            throw new IllegalArgumentException("ldcf(P) != 1: " + P);
        }
        SortedMap<Long, GenPolynomial<MOD>> dfacs = this.baseDistinctDegreeFactors(P);
        for (Map.Entry<Long, GenPolynomial<MOD>> me : dfacs.entrySet()) {
            Long e = me.getKey();
            GenPolynomial<MOD> f = me.getValue();
            List<GenPolynomial<MOD>> efacs = this.baseEqualDegreeFactors(f, e);
            factors.addAll(efacs);
        }
        factors = PolyUtil.monic(factors);
        TreeSet ss = new TreeSet(factors);
        factors.clear();
        factors.addAll(ss);
        return factors;
    }
}

