/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLong;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLongRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Complex;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ComplexRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAlgebraic;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorComplex;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorModular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorQuotient;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Quotient;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.QuotientRing;

public class FactorFactory {
    public static FactorAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        return new FactorModular<ModInteger>(fac);
    }

    public static FactorAbstract<ModLong> getImplementation(ModLongRing fac) {
        return new FactorModular<ModLong>(fac);
    }

    public static FactorAbstract<BigInteger> getImplementation(BigInteger fac) {
        return new FactorInteger();
    }

    public static FactorAbstract<BigRational> getImplementation(BigRational fac) {
        return new FactorRational();
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> fac) {
        return new FactorAlgebraic<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Complex<C>> getImplementation(ComplexRing<C> fac) {
        return new FactorComplex<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac) {
        return new FactorQuotient<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(GenPolynomialRing<C> fac) {
        return FactorFactory.getImplementation(fac.coFac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(RingFactory<C> fac) {
        FactorAbstract ufd;
        RingFactory<C> ofac = fac;
        if (ofac instanceof BigInteger) {
            ufd = new FactorInteger();
        } else if (ofac instanceof BigRational) {
            ufd = new FactorRational();
        } else if (ofac instanceof ModIntegerRing) {
            ufd = new FactorModular<C>(fac);
        } else if (ofac instanceof ModLongRing) {
            ufd = new FactorModular<C>(fac);
        } else if (ofac instanceof ComplexRing) {
            ComplexRing cfac = (ComplexRing)ofac;
            ufd = new FactorComplex(cfac);
        } else if (ofac instanceof AlgebraicNumberRing) {
            AlgebraicNumberRing afac = (AlgebraicNumberRing)ofac;
            ufd = new FactorAlgebraic(afac);
        } else if (ofac instanceof QuotientRing) {
            QuotientRing qfac = (QuotientRing)ofac;
            ufd = new FactorQuotient(qfac);
        } else if (ofac instanceof GenPolynomialRing) {
            GenPolynomialRing pfac = (GenPolynomialRing)ofac;
            ufd = FactorFactory.getImplementation(pfac.coFac);
        } else {
            throw new IllegalArgumentException("no factorization implementation for " + fac.getClass().getName());
        }
        return ufd;
    }
}

