/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.OrderedPolynomialList;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PolynomialList<C extends RingElem<C>>
implements Comparable<PolynomialList<C>>,
Serializable {
    public final GenPolynomialRing<C> ring;
    public final List<GenPolynomial<C>> list;

    public PolynomialList(GenPolynomialRing<C> r, List<GenPolynomial<C>> l) {
        this.ring = r;
        this.list = l;
    }

    public PolynomialList<C> copy() {
        return new PolynomialList<C>(this.ring, new ArrayList<GenPolynomial<C>>(this.list));
    }

    public boolean equals(Object p) {
        if (!(p instanceof PolynomialList)) {
            return false;
        }
        PolynomialList pl = null;
        try {
            pl = (PolynomialList)p;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (pl == null) {
            return false;
        }
        if (!this.ring.equals(pl.ring)) {
            return false;
        }
        return this.compareTo(pl) == 0;
    }

    @Override
    public int compareTo(PolynomialList<C> L) {
        int si = L.list.size();
        if (this.list.size() < si) {
            si = this.list.size();
        }
        int s = 0;
        List<GenPolynomial<C>> l1 = OrderedPolynomialList.sort(this.ring, this.list);
        List<GenPolynomial<C>> l2 = OrderedPolynomialList.sort(this.ring, L.list);
        for (int i = 0; i < si; ++i) {
            GenPolynomial<C> b;
            GenPolynomial<C> a = l1.get(i);
            s = a.compareTo(b = l2.get(i));
            if (s == 0) continue;
            return s;
        }
        if (this.list.size() > si) {
            return 1;
        }
        if (L.list.size() > si) {
            return -1;
        }
        return s;
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + (this.list == null ? 0 : this.list.hashCode());
        return h;
    }

    public String toString() {
        StringBuilder erg = new StringBuilder();
        String[] vars = null;
        if (this.ring != null) {
            erg.append(this.ring.toString());
            vars = this.ring.getVars();
        }
        boolean first = true;
        erg.append("\n(\n");
        String sa = null;
        for (GenPolynomial<C> oa : this.list) {
            sa = vars != null ? oa.toString(vars) : oa.toString();
            if (first) {
                first = false;
            } else {
                erg.append(", ");
                if (sa.length() > 10) {
                    erg.append("\n");
                }
            }
            erg.append("( ").append(sa).append(" )");
        }
        erg.append("\n)");
        return erg.toString();
    }
}

