/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenSolvablePolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.RelationTable;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.TermOrder;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class GenSolvablePolynomialRing<C extends RingElem<C>>
extends GenPolynomialRing<C> {
    public final RelationTable<C> table;
    public final GenSolvablePolynomial<C> ZERO;
    public final GenSolvablePolynomial<C> ONE;

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v) {
        this(cf, n, t, v, null);
    }

    public GenSolvablePolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v, RelationTable<C> rt) {
        super(cf, n, t, v);
        this.table = rt == null ? new RelationTable(this) : rt;
        this.ZERO = new GenSolvablePolynomial(this);
        RingElem coeff = (RingElem)this.coFac.getONE();
        this.ONE = new GenSolvablePolynomial<RingElem>(this, coeff, this.evzero);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "\n" + this.table.toString(this.vars);
        return res;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GenSolvablePolynomialRing)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        GenSolvablePolynomialRing oring = null;
        try {
            oring = (GenSolvablePolynomialRing)other;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return oring != null;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 37 * h + this.table.hashCode();
        return h;
    }

    @Override
    public GenSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.table.size() == 0) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        for (int i = 0; i < this.nvar; ++i) {
            GenPolynomial Xi = this.univariate(i);
            for (int j = i + 1; j < this.nvar; ++j) {
                GenPolynomial Xj = this.univariate(j);
                for (int k = j + 1; k < this.nvar; ++k) {
                    GenSolvablePolynomial<GenSolvablePolynomial<GenPolynomial>> q;
                    GenPolynomial Xk = this.univariate(k);
                    GenSolvablePolynomial<GenPolynomial> p = ((GenSolvablePolynomial)Xk).multiply(Xj).multiply(Xi);
                    if (p.equals(q = ((GenSolvablePolynomial)Xk).multiply(((GenSolvablePolynomial)Xj).multiply(Xi)))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public GenSolvablePolynomial<C> fromInteger(long a) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenSolvablePolynomial<C> fromInteger(BigInteger a) {
        return new GenSolvablePolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenSolvablePolynomial<C> copy(GenSolvablePolynomial<C> c) {
        return new GenSolvablePolynomial(this, c.val);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int i) {
        return (GenSolvablePolynomial)super.univariate(i);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int i, long e) {
        return (GenSolvablePolynomial)super.univariate(i, e);
    }

    @Override
    public GenSolvablePolynomial<C> univariate(int modv, int i, long e) {
        return (GenSolvablePolynomial)super.univariate(modv, i, e);
    }

    @Override
    public List<GenSolvablePolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<GenSolvablePolynomial<C>> univariateList(int modv, long e) {
        ArrayList<GenSolvablePolynomial<C>> pols = new ArrayList<GenSolvablePolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenPolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add((GenSolvablePolynomial<C>)p);
        }
        return pols;
    }

    @Override
    public GenSolvablePolynomialRing<C> extend(int i) {
        GenPolynomialRing pfac = super.extend(i);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.table.extend(this.table);
        return spfac;
    }

    @Override
    public GenSolvablePolynomialRing<C> contract(int i) {
        GenPolynomialRing pfac = super.contract(i);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.table.contract(this.table);
        return spfac;
    }

    @Override
    public GenSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public GenSolvablePolynomialRing<C> reverse(boolean partial) {
        GenPolynomialRing pfac = super.reverse(partial);
        GenSolvablePolynomialRing spfac = new GenSolvablePolynomialRing(pfac.coFac, pfac.nvar, pfac.tord, pfac.vars);
        spfac.partial = partial;
        spfac.table.reverse(this.table);
        return spfac;
    }
}

