/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;

public final class ExpVectorShort
extends ExpVector {
    final short[] val;
    public static final long maxShort = 16383L;
    public static final long minShort = -16384L;

    public ExpVectorShort(int n) {
        this(new short[n]);
    }

    public ExpVectorShort(int n, int i, long e) {
        this(n);
        if (e >= 16383L || e <= -16384L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (short)e;
    }

    protected ExpVectorShort(short[] v) {
        this.val = v;
    }

    public ExpVectorShort(long[] v) {
        this(v.length);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] >= 16383L || v[i] <= -16384L) {
                throw new IllegalArgumentException("exponent to large: " + v[i]);
            }
            this.val[i] = (short)v[i];
        }
    }

    @Override
    public ExpVectorShort copy() {
        short[] w = new short[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorShort(w);
    }

    @Override
    long[] getVal() {
        long[] v = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            v[i] = this.val[i];
        }
        return v;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        short x = this.val[i];
        if (e >= 16383L || e <= -16384L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (short)e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorShort extend(int i, int j, long e) {
        short[] w = new short[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        if (e >= 16383L || e <= -16384L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        w[j] = (short)e;
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort extendLower(int i, int j, long e) {
        short[] w = new short[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = (short)e;
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        short[] w = new short[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort reverse() {
        short[] w = new short[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort reverse(int j) {
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        short[] w = new short[this.val.length];
        for (int i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        System.arraycopy(this.val, j, w, j, this.val.length - j);
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorShort Vi = (ExpVectorShort)V;
        if (this.val.length == 0) {
            return Vi;
        }
        short[] w = new short[this.val.length + Vi.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vi.val, 0, w, this.val.length, Vi.val.length);
        return new ExpVectorShort(w);
    }

    @Override
    public String toString() {
        return super.toString() + ":short";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorShort)) {
            return false;
        }
        ExpVectorShort b = (ExpVectorShort)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public ExpVectorShort abs() {
        short[] u = this.val;
        short[] w = new short[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (long)u[i] >= 0L ? u[i] : (short)(-u[i]);
        }
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort negate() {
        short[] u = this.val;
        short[] w = new short[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort sum(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        short[] w = new short[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (short)(u[i] + v[i]);
        }
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort subtract(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        short[] w = new short[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (short)(u[i] - v[i]);
        }
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort subst(int i, long d) {
        ExpVectorShort V = this.copy();
        return V;
    }

    @Override
    public int signum() {
        short[] u;
        int t = 0;
        for (short anU : u = this.val) {
            if (anU < 0) {
                return -1;
            }
            if (anU <= 0) continue;
            t = 1;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        short[] u;
        long t = 0L;
        for (short anU : u = this.val) {
            t += (long)anU;
        }
        return t;
    }

    @Override
    public long maxDeg() {
        short[] u;
        long t = 0L;
        for (short anU : u = this.val) {
            if ((long)anU <= t) continue;
            t = anU;
        }
        return t;
    }

    @Override
    public ExpVectorShort lcm(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        short[] w = new short[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return new ExpVectorShort(w);
    }

    @Override
    public ExpVectorShort gcd(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        short[] w = new short[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return new ExpVectorShort(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        short[] u = this.val;
        int l = 0;
        for (short anU : u) {
            if (anU <= 0) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        short[] u = this.val;
        short[] v = ((ExpVectorShort)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (long[] wk : w) {
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }
}

