/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;

public final class ExpVectorInteger
extends ExpVector {
    final int[] val;
    public static final long maxInt = 0x3FFFFFFFL;
    public static final long minInt = -1073741824L;

    public ExpVectorInteger(int n) {
        this(new int[n]);
    }

    public ExpVectorInteger(int n, int i, long e) {
        this(n);
        if (e >= 0x3FFFFFFFL || e <= -1073741824L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (int)e;
    }

    protected ExpVectorInteger(int[] v) {
        this.val = v;
    }

    public ExpVectorInteger(long[] v) {
        this(v.length);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] >= 0x3FFFFFFFL || v[i] <= -1073741824L) {
                throw new IllegalArgumentException("exponent to large: " + v[i]);
            }
            this.val[i] = (int)v[i];
        }
    }

    @Override
    public ExpVectorInteger copy() {
        int[] w = new int[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorInteger(w);
    }

    @Override
    long[] getVal() {
        long[] v = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            v[i] = this.val[i];
        }
        return v;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        int x = this.val[i];
        if (e >= 0x3FFFFFFFL || e <= -1073741824L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (int)e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorInteger extend(int i, int j, long e) {
        int[] w = new int[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        if (e >= 0x3FFFFFFFL || e <= -1073741824L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        w[j] = (int)e;
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger extendLower(int i, int j, long e) {
        int[] w = new int[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = (int)e;
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        int[] w = new int[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger reverse() {
        int[] w = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger reverse(int j) {
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        int[] w = new int[this.val.length];
        for (int i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        System.arraycopy(this.val, j, w, j, this.val.length - j);
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorInteger Vi = (ExpVectorInteger)V;
        if (this.val.length == 0) {
            return Vi;
        }
        int[] w = new int[this.val.length + Vi.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vi.val, 0, w, this.val.length, Vi.val.length);
        return new ExpVectorInteger(w);
    }

    @Override
    public String toString() {
        return super.toString() + ":int";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorInteger)) {
            return false;
        }
        ExpVectorInteger b = (ExpVectorInteger)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public ExpVectorInteger abs() {
        int[] u = this.val;
        int[] w = new int[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (long)u[i] >= 0L ? u[i] : -u[i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger negate() {
        int[] u = this.val;
        int[] w = new int[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger sum(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] + v[i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger subtract(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] - v[i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger subst(int i, long d) {
        ExpVectorInteger V = this.copy();
        return V;
    }

    @Override
    public int signum() {
        int[] u;
        int t = 0;
        for (int anU : u = this.val) {
            if (anU < 0) {
                return -1;
            }
            if (anU <= 0) continue;
            t = 1;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        int[] u;
        long t = 0L;
        for (int anU : u = this.val) {
            t += (long)anU;
        }
        return t;
    }

    @Override
    public long maxDeg() {
        int[] u;
        long t = 0L;
        for (int anU : u = this.val) {
            if ((long)anU <= t) continue;
            t = anU;
        }
        return t;
    }

    @Override
    public ExpVectorInteger lcm(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public ExpVectorInteger gcd(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int[] w = new int[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return new ExpVectorInteger(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        int[] u = this.val;
        int l = 0;
        for (int anU : u) {
            if (anU <= 0) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        int[] u = this.val;
        int[] v = ((ExpVectorInteger)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (long[] wk : w) {
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }
}

