/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVectorByte;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVectorInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVectorLong;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVectorShort;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupFactory;
import java.util.Collection;
import java.util.Random;

public abstract class ExpVector
implements AbelianGroupElem<ExpVector> {
    protected int hash = 0;
    private static final Random random = new Random();
    public static final StorUnit storunit = StorUnit.LONG;

    public static ExpVector create(int n) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(n);
            }
            case LONG: {
                return new ExpVectorLong(n);
            }
            case SHORT: {
                return new ExpVectorShort(n);
            }
            case BYTE: {
                return new ExpVectorByte(n);
            }
        }
        return new ExpVectorInteger(n);
    }

    public static ExpVector create(int n, int i, long e) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(n, i, e);
            }
            case LONG: {
                return new ExpVectorLong(n, i, e);
            }
            case SHORT: {
                return new ExpVectorShort(n, i, e);
            }
            case BYTE: {
                return new ExpVectorByte(n, i, e);
            }
        }
        return new ExpVectorInteger(n, i, e);
    }

    public static ExpVector create(long[] v) {
        switch (storunit) {
            case INT: {
                return new ExpVectorInteger(v);
            }
            case LONG: {
                return new ExpVectorLong(v);
            }
            case SHORT: {
                return new ExpVectorShort(v);
            }
            case BYTE: {
                return new ExpVectorByte(v);
            }
        }
        return new ExpVectorInteger(v);
    }

    public static ExpVector create(Collection<Long> v) {
        long[] w = new long[v.size()];
        int i = 0;
        for (Long k : v) {
            w[i++] = k;
        }
        return ExpVector.create(w);
    }

    @Override
    public AbelianGroupFactory<ExpVector> factory() {
        throw new UnsupportedOperationException("no factory implemented for ExpVector");
    }

    public boolean isFinite() {
        return true;
    }

    @Override
    public abstract ExpVector copy();

    abstract long[] getVal();

    public abstract long getVal(int var1);

    protected abstract long setVal(int var1, long var2);

    public abstract int length();

    public abstract ExpVector extend(int var1, int var2, long var3);

    public abstract ExpVector extendLower(int var1, int var2, long var3);

    public abstract ExpVector contract(int var1, int var2);

    public abstract ExpVector reverse();

    public abstract ExpVector reverse(int var1);

    public abstract ExpVector combine(ExpVector var1);

    public String toString() {
        StringBuilder s = new StringBuilder("(");
        for (int i = 0; i < this.length(); ++i) {
            s.append(this.getVal(i));
            if (i >= this.length() - 1) continue;
            s.append(",");
        }
        s.append(")");
        return s.toString();
    }

    public String toString(String[] vars) {
        long vi;
        StringBuilder s = new StringBuilder();
        int r = this.length();
        if (r != vars.length) {
            return this.toString();
        }
        if (r == 0) {
            return s.toString();
        }
        for (int i = r - 1; i > 0; --i) {
            vi = this.getVal(i);
            if (vi == 0L) continue;
            s.append(vars[r - 1 - i]);
            if (vi != 1L) {
                s.append("^").append(vi);
            }
            boolean pit = false;
            for (int j = i - 1; j >= 0; --j) {
                if (this.getVal(j) == 0L) continue;
                pit = true;
            }
            if (!pit) continue;
            s.append(" * ");
        }
        vi = this.getVal(0);
        if (vi != 0L) {
            s.append(vars[r - 1]);
            if (vi != 1L) {
                s.append("^").append(vi);
            }
        }
        return s.toString();
    }

    public static String varsToString(String[] vars) {
        if (vars == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < vars.length; ++i) {
            s.append(vars[i]);
            if (i >= vars.length - 1) continue;
            s.append(",");
        }
        return s.toString();
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVector)) {
            return false;
        }
        ExpVector b = (ExpVector)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            for (int i = 0; i < this.length(); ++i) {
                this.hash <<= (int)(4L + this.getVal(i));
            }
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    @Override
    public boolean isZERO() {
        return 0 == this.signum();
    }

    @Override
    public abstract ExpVector abs();

    @Override
    public abstract ExpVector negate();

    @Override
    public abstract ExpVector sum(ExpVector var1);

    @Override
    public abstract ExpVector subtract(ExpVector var1);

    public ExpVector subst(int i, long d) {
        ExpVector V = this.copy();
        return V;
    }

    public static ExpVector EVRAND(int r, long k, float q, Random rnd) {
        long[] w = new long[r];
        for (int i = 0; i < w.length; ++i) {
            long e;
            float f = rnd.nextFloat();
            if (f > q) {
                e = 0L;
            } else {
                e = rnd.nextLong() % k;
                if (e < 0L) {
                    e = -e;
                }
            }
            w[i] = e;
        }
        return ExpVector.create(w);
    }

    public static ExpVector random(int r, long k, float q) {
        return ExpVector.EVRAND(r, k, q, random);
    }

    public static ExpVector random(int r, long k, float q, Random rnd) {
        return ExpVector.EVRAND(r, k, q, rnd);
    }

    @Override
    public abstract int signum();

    public long degree() {
        return this.totalDeg();
    }

    public abstract long totalDeg();

    public abstract long maxDeg();

    public abstract ExpVector lcm(ExpVector var1);

    public abstract ExpVector gcd(ExpVector var1);

    public abstract int[] dependencyOnVariables();

    public abstract boolean multipleOf(ExpVector var1);

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    public static int EVILCP(ExpVector U, ExpVector V) {
        return U.invLexCompareTo(V);
    }

    public abstract int invLexCompareTo(ExpVector var1);

    public static int EVILCP(ExpVector U, ExpVector V, int begin, int end) {
        return U.invLexCompareTo(V, begin, end);
    }

    public abstract int invLexCompareTo(ExpVector var1, int var2, int var3);

    public static int EVIGLC(ExpVector U, ExpVector V) {
        return U.invGradCompareTo(V);
    }

    public abstract int invGradCompareTo(ExpVector var1);

    public static int EVIGLC(ExpVector U, ExpVector V, int begin, int end) {
        return U.invGradCompareTo(V, begin, end);
    }

    public abstract int invGradCompareTo(ExpVector var1, int var2, int var3);

    public static int EVRILCP(ExpVector U, ExpVector V) {
        return U.revInvLexCompareTo(V);
    }

    public abstract int revInvLexCompareTo(ExpVector var1);

    public static int EVRILCP(ExpVector U, ExpVector V, int begin, int end) {
        return U.revInvLexCompareTo(V, begin, end);
    }

    public abstract int revInvLexCompareTo(ExpVector var1, int var2, int var3);

    public static int EVRIGLC(ExpVector U, ExpVector V) {
        return U.revInvGradCompareTo(V);
    }

    public abstract int revInvGradCompareTo(ExpVector var1);

    public static int EVRIGLC(ExpVector U, ExpVector V, int begin, int end) {
        return U.revInvGradCompareTo(V, begin, end);
    }

    public abstract int revInvGradCompareTo(ExpVector var1, int var2, int var3);

    public static int EVIWLC(long[][] w, ExpVector U, ExpVector V) {
        return U.invWeightCompareTo(w, V);
    }

    public abstract int invWeightCompareTo(long[][] var1, ExpVector var2);

    public static enum StorUnit {
        LONG,
        INT,
        SHORT,
        BYTE;

    }
}

