/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.CartesianProduct;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.CartesianProductInfinite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class AlgebraicNumberIterator<C extends RingElem<C>>
implements Iterator<AlgebraicNumber<C>> {
    final Iterator<List<C>> iter;
    final List<GenPolynomial<C>> powers;
    final AlgebraicNumberRing<C> aring;

    public AlgebraicNumberIterator(AlgebraicNumberRing<C> aring) {
        RingFactory cf = aring.ring.coFac;
        this.aring = aring;
        long d = aring.modul.degree(0);
        this.powers = new ArrayList<GenPolynomial<C>>((int)d);
        for (long j = d - 1L; j >= 0L; --j) {
            this.powers.add(aring.ring.univariate(0, j));
        }
        if (!(cf instanceof Iterable)) {
            throw new IllegalArgumentException("only for iterable coefficients implemented");
        }
        ArrayList<Iterable<Iterable>> comps = new ArrayList<Iterable<Iterable>>((int)d);
        Iterable cfi = (Iterable)((Object)cf);
        for (long j = 0L; j < d; ++j) {
            comps.add(cfi);
        }
        if (cf.isFinite()) {
            CartesianProduct tuples = new CartesianProduct(comps);
            this.iter = tuples.iterator();
        } else {
            CartesianProductInfinite tuples = new CartesianProductInfinite(comps);
            this.iter = tuples.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public AlgebraicNumber<C> next() {
        List<C> coeffs = this.iter.next();
        GenPolynomial<GenPolynomial<RingElem>> pol = this.aring.ring.getZERO();
        int i = 0;
        for (GenPolynomial<RingElem> genPolynomial : this.powers) {
            RingElem c;
            if ((c = (RingElem)coeffs.get(i++)).isZERO()) continue;
            pol = pol.sum(genPolynomial.multiply(c));
        }
        return new AlgebraicNumber<C>(this.aring, pol);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

