/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.expand;

import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.AbstractExpandTransformation;
import cc.redberry.core.transformations.expand.ExpandUtils;
import cc.redberry.core.transformations.fractions.NumeratorDenominator;

public final class ExpandAllTransformation
extends AbstractExpandTransformation {
    public static final ExpandAllTransformation EXPAND_ALL = new ExpandAllTransformation();

    private ExpandAllTransformation() {
        super(new Transformation[0], TraverseGuide.ALL);
    }

    public ExpandAllTransformation(Transformation[] transformations) {
        super(transformations, TraverseGuide.ALL);
    }

    public ExpandAllTransformation(Transformation[] transformations, TraverseGuide traverseGuide) {
        super(transformations, traverseGuide);
    }

    public static Tensor expandAll(Tensor tensor) {
        return EXPAND_ALL.transform(tensor);
    }

    public static Tensor expandAll(Tensor tensor, Transformation ... transformations) {
        return new ExpandAllTransformation(transformations).transform(tensor);
    }

    @Override
    protected Tensor expandProduct(Product product, Transformation[] transformations) {
        Tensor res;
        NumeratorDenominator numDen = NumeratorDenominator.getNumeratorAndDenominator(product, NumeratorDenominator.integerDenominatorIndicator);
        Tensor denominator = numDen.denominator;
        if (denominator instanceof Product) {
            denominator = ExpandUtils.expandProductOfSums((Product)numDen.denominator, transformations);
        }
        boolean denExpanded = denominator != numDen.denominator;
        denominator = Tensors.reciprocal(denominator);
        Tensor numerator = numDen.numerator;
        Tensor temp = res = Tensors.multiply(denominator, numerator);
        if (res instanceof Product) {
            res = ExpandUtils.expandProductOfSums((Product)temp, transformations);
        }
        if (denExpanded || res != temp) {
            return res;
        }
        return product;
    }
}

