/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;

public interface Transformation {
    public static final Transformation INDENTITY = new Transformation(){

        @Override
        public Tensor transform(Tensor t) {
            return t;
        }
    };

    public Tensor transform(Tensor var1);

    public static final class Util {
        private Util() {
        }

        public static Tensor applySequentially(Tensor tensor, Transformation ... transformations) {
            for (Transformation tr : transformations) {
                tensor = tr.transform(tensor);
            }
            return tensor;
        }

        public static Tensor applyToEachChild(Tensor tensor, Transformation transformation) {
            TensorBuilder builder = null;
            int size = tensor.size();
            for (int i = 0; i < size; ++i) {
                Tensor oc = tensor.get(i);
                Tensor c = transformation.transform(oc);
                if (builder == null && c == oc) continue;
                if (builder == null) {
                    builder = tensor.getBuilder();
                    for (int j = 0; j < i; ++j) {
                        builder.put(tensor.get(j));
                    }
                }
                builder.put(c);
            }
            if (builder == null) {
                return tensor;
            }
            return builder.build();
        }

        public static Tensor applyUntilUnchanged(Tensor t, Transformation transformation) {
            Tensor r;
            while ((r = t) != (t = transformation.transform(r))) {
            }
            return r;
        }
    }
}

