/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.Transformation;

public class ToNumericTransformation
implements Transformation {
    public static final ToNumericTransformation TO_NUMERIC = new ToNumericTransformation();

    private ToNumericTransformation() {
    }

    @Override
    public Tensor transform(Tensor t) {
        return ToNumericTransformation.toNumeric(t);
    }

    public static Tensor toNumeric(Tensor t) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (!(c instanceof Complex)) continue;
            iterator.set(((Complex)c).getNumericValue());
        }
        return iterator.result();
    }
}

