/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.indexmapping.IndexMapping;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public final class EliminateMetricsTransformation
implements Transformation {
    public static final EliminateMetricsTransformation ELIMINATE_METRICS = new EliminateMetricsTransformation();

    public static Tensor eliminate(Tensor t) {
        return ELIMINATE_METRICS.transform(t);
    }

    private EliminateMetricsTransformation() {
    }

    @Override
    public Tensor transform(Tensor tensor) {
        return this.transform(tensor, DummyMetricsChain.INSTANCE);
    }

    private Tensor transform(Tensor tensor, MetricsChain chain) {
        if (tensor instanceof SimpleTensor) {
            if ((tensor = chain.apply((SimpleTensor)tensor)) instanceof TensorField) {
                boolean applied = false;
                TensorBuilder builder = tensor.getBuilder();
                int size = tensor.size();
                for (int i = 0; i < size; ++i) {
                    Tensor temp;
                    Tensor current = tensor.get(i);
                    if (current != (temp = this.transform(current))) {
                        applied = true;
                    }
                    builder.put(temp);
                }
                if (applied) {
                    tensor = builder.build();
                }
            }
            return tensor;
        }
        if (tensor instanceof Product) {
            Tensor current;
            int i;
            MetricsChainImpl tempContainer = new MetricsChainImpl(chain);
            ArrayList<Tensor> nonMetrics = new ArrayList<Tensor>();
            boolean applied = false;
            for (i = tensor.size() - 1; i >= 0; --i) {
                current = tensor.get(i);
                if (Tensors.isKroneckerOrMetric(current)) {
                    applied |= tempContainer.add(new MetricWrapper(current));
                    continue;
                }
                nonMetrics.add(current);
            }
            for (i = nonMetrics.size() - 1; i >= 0; --i) {
                Tensor temp = (Tensor)nonMetrics.get(i);
                current = this.transform(temp, tempContainer);
                if (current == temp) continue;
                applied = true;
                nonMetrics.set(i, current);
            }
            if (!applied) {
                return tensor;
            }
            ProductBuilder builder = new ProductBuilder();
            for (Tensor nonMetric : nonMetrics) {
                builder.put(nonMetric);
            }
            for (MetricWrapper mk : tempContainer.container) {
                builder.put(mk.metric);
            }
            return builder.build();
        }
        if (tensor instanceof Sum || tensor instanceof Expression) {
            Tensor[] data = new Tensor[tensor.size()];
            boolean applied = false;
            for (int i = tensor.size() - 1; i >= 0; --i) {
                Tensor oldTensor = tensor.get(i);
                Tensor newTensor = i == 0 ? this.transform(oldTensor, chain) : this.transform(oldTensor, chain.clone());
                data[i] = newTensor;
                if (oldTensor == newTensor) continue;
                applied = true;
            }
            if (!applied) {
                return tensor;
            }
            TensorBuilder builder = tensor.getBuilder();
            for (Tensor term : data) {
                builder.put(term);
            }
            return builder.build();
        }
        Tensor[] rebuild = new Tensor[tensor.size()];
        boolean modified = false;
        for (int i = tensor.size() - 1; i >= 0; --i) {
            Tensor temp = this.transform(tensor.get(i));
            if (temp != tensor.get(i)) {
                modified = true;
            }
            rebuild[i] = temp;
        }
        if (!modified) {
            return tensor;
        }
        return tensor.getFactory().create(rebuild);
    }

    private static final class MetricWrapper
    implements Comparable<MetricWrapper> {
        final int[] indices = new int[2];
        Tensor metric;

        MetricWrapper(Tensor tensorMK) {
            this.indices[0] = tensorMK.getIndices().get(0);
            this.indices[1] = tensorMK.getIndices().get(1);
            Arrays.sort(this.indices);
            this.metric = tensorMK;
        }

        private MetricWrapper(int index1, int index2, Tensor tensorMK) {
            this.indices[0] = index1;
            this.indices[1] = index2;
            this.metric = tensorMK;
        }

        @Override
        public int compareTo(MetricWrapper o) {
            int res = Integer.compare(this.indices[0], o.indices[0]);
            if (res != 0) {
                return res;
            }
            return Integer.compare(this.indices[1], o.indices[1]);
        }

        SimpleTensor apply(SimpleTensor t) {
            IM im;
            SimpleIndices newIndices;
            SimpleIndices oldIndices = t.getIndices();
            int from = -1;
            int to = -1;
            block0: for (int i = 0; i < oldIndices.size(); ++i) {
                for (int j = 0; j < 2; ++j) {
                    if ((oldIndices.get(i) ^ this.indices[j]) != Integer.MIN_VALUE) continue;
                    from = oldIndices.get(i);
                    to = this.indices[1 - j];
                    break block0;
                }
            }
            if (oldIndices == (newIndices = oldIndices.applyIndexMapping(im = new IM(from, to)))) {
                return t;
            }
            if (t.getClass() == SimpleTensor.class) {
                return Tensors.simpleTensor(t.getName(), newIndices);
            }
            TensorField ff = (TensorField)t;
            return Tensors.field(ff.getName(), newIndices, ff.getArgIndices(), ff.getArguments());
        }

        boolean apply(MetricWrapper mK) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if ((this.indices[i] ^ mK.indices[j]) != Integer.MIN_VALUE) continue;
                    this.metric = Tensors.createMetricOrKronecker(this.indices[1 - i], mK.indices[1 - j]);
                    this.indices[i] = mK.indices[1 - j];
                    Arrays.sort(this.indices);
                    return true;
                }
            }
            return false;
        }

        public MetricWrapper clone() {
            SimpleTensor t = Tensors.createMetricOrKronecker(this.indices[0], this.indices[1]);
            return new MetricWrapper(this.indices[0], this.indices[1], t);
        }

        public String toString() {
            return this.metric.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetricWrapper other = (MetricWrapper)obj;
            return Arrays.equals(this.indices, other.indices);
        }

        private class IM
        implements IndexMapping {
            final int from;
            final int to;

            public IM(int from, int to) {
                this.from = from;
                this.to = to;
            }

            @Override
            public int map(int from) {
                return from == this.from ? this.to : from;
            }
        }
    }

    private static final class DummyMetricsChain
    implements MetricsChain {
        static final DummyMetricsChain INSTANCE = new DummyMetricsChain();

        private DummyMetricsChain() {
        }

        @Override
        public boolean mergeWith(MetricWrapper mk) {
            return false;
        }

        @Override
        public boolean add(MetricWrapper mK) {
            throw new IllegalStateException();
        }

        @Override
        public SimpleTensor apply(SimpleTensor t) {
            return t;
        }

        @Override
        public MetricsChain clone() {
            return INSTANCE;
        }

        @Override
        public boolean equals(MetricsChain gc) {
            return gc instanceof DummyMetricsChain;
        }

        public String toString() {
            return "RootMetricKroneckerContainer";
        }
    }

    private static final class MetricsChainImpl
    implements MetricsChain {
        final MetricsChain parent;
        List<MetricWrapper> container;

        MetricsChainImpl(MetricsChain parent) {
            this.container = new ArrayList<MetricWrapper>();
            this.parent = parent;
        }

        private MetricsChainImpl(List<MetricWrapper> container, MetricsChain parent) {
            this.container = container;
            this.parent = parent;
        }

        @Override
        public boolean mergeWith(MetricWrapper mk) {
            boolean b = false;
            ListIterator<MetricWrapper> it = this.container.listIterator();
            while (it.hasNext()) {
                MetricWrapper _mk = it.next();
                if (!mk.apply(_mk)) continue;
                it.remove();
                b = true;
            }
            return this.parent.mergeWith(mk) || b;
        }

        @Override
        public boolean add(MetricWrapper mK) {
            return this.mergeWith(mK) | !this.container.add(mK);
        }

        @Override
        public SimpleTensor apply(SimpleTensor t) {
            SimpleTensor newVal;
            ListIterator<MetricWrapper> iterator = this.container.listIterator();
            SimpleTensor oldVal = t;
            while (iterator.hasNext()) {
                MetricWrapper current = iterator.next();
                newVal = current.apply(oldVal);
                if (newVal == oldVal) continue;
                iterator.remove();
                oldVal = newVal;
            }
            newVal = this.parent.apply(oldVal);
            return newVal;
        }

        @Override
        public MetricsChainImpl clone() {
            ArrayList<MetricWrapper> newList = new ArrayList<MetricWrapper>();
            for (MetricWrapper mk : this.container) {
                newList.add(mk.clone());
            }
            return new MetricsChainImpl(newList, this.parent.clone());
        }

        @Override
        public boolean equals(MetricsChain gC) {
            if (gC instanceof DummyMetricsChain) {
                return false;
            }
            MetricsChainImpl gc = (MetricsChainImpl)gC;
            if (this.container.size() != gc.container.size()) {
                return false;
            }
            Collections.sort(this.container);
            Collections.sort(gc.container);
            for (int i = 0; i < this.container.size(); ++i) {
                if (this.container.get(i).equals(gc.container.get(i))) continue;
                return false;
            }
            return this.parent.equals(gc.parent);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (MetricWrapper mk : this.container) {
                sb.append(mk.toString()).append(";");
            }
            return sb.toString();
        }
    }

    private static interface MetricsChain {
        public boolean mergeWith(MetricWrapper var1);

        public boolean add(MetricWrapper var1);

        public SimpleTensor apply(SimpleTensor var1);

        public MetricsChain clone();

        public boolean equals(MetricsChain var1);
    }
}

