/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ScalarsBackedProductBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.TensorUtils;

public class CollectScalarFactorsTransformation
implements Transformation {
    public static final CollectScalarFactorsTransformation COLLECT_SCALAR_FACTORS = new CollectScalarFactorsTransformation();
    private final TraverseGuide traverseGuide;

    private CollectScalarFactorsTransformation() {
        this.traverseGuide = TraverseGuide.ALL;
    }

    public CollectScalarFactorsTransformation(TraverseGuide traverseGuide) {
        this.traverseGuide = traverseGuide;
    }

    @Override
    public Tensor transform(Tensor t) {
        return CollectScalarFactorsTransformation.collectScalarFactors(t, this.traverseGuide);
    }

    public static Tensor collectScalarFactors(Tensor tensor) {
        return CollectScalarFactorsTransformation.collectScalarFactors(tensor, TraverseGuide.ALL);
    }

    public static Tensor collectScalarFactors(Tensor tensor, TraverseGuide traverseGuide) {
        Tensor current;
        FromChildToParentIterator iterator = new FromChildToParentIterator(tensor, traverseGuide);
        while ((current = iterator.next()) != null) {
            if (!(current instanceof Product)) continue;
            iterator.set(CollectScalarFactorsTransformation.collectScalarFactorsInProduct((Product)current));
        }
        return iterator.result();
    }

    public static Tensor collectScalarFactorsInProduct(Product product) {
        if (TensorUtils.isSymbolic((Tensor)product)) {
            return product;
        }
        ScalarsBackedProductBuilder builder = new ScalarsBackedProductBuilder(product.size(), 1, product.getIndices().getFree().size());
        builder.put(product);
        return builder.build();
    }
}

