/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensorgenerator;

import cc.redberry.core.combinatorics.IntCombinationsGenerator;
import cc.redberry.core.context.CC;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.util.ArithmeticUtils;

public final class TensorGeneratorUtils {
    private TensorGeneratorUtils() {
    }

    public static Tensor[] allStatesCombinations(Tensor st) {
        Indices indices = st.getIndices().getFree();
        int[] indicesArray = indices.getAllIndices().copy();
        IntArrayList metricIndices = new IntArrayList();
        IntArrayList nonMetricIndices = new IntArrayList();
        for (int i = 0; i < indices.size(); ++i) {
            if (CC.isMetric(IndicesUtils.getType(indices.get(i)))) {
                metricIndices.add(IndicesUtils.getNameWithType(indices.get(i)));
                continue;
            }
            nonMetricIndices.add(indices.get(i));
        }
        int[] metricInds = metricIndices.toArray();
        ArrayList samples = new ArrayList(ArithmeticUtils.pow((int)2, (int)metricInds.length));
        for (int i = 0; i <= metricInds.length; ++i) {
            IntCombinationsGenerator gen = new IntCombinationsGenerator(metricInds.length, i);
            ArrayList<Tensor> combinationArray = new ArrayList<Tensor>();
            block2: for (int[] combination : gen) {
                int[] temp = new int[metricInds.length];
                Arrays.fill(temp, -1);
                for (int j = combination.length - 1; j >= 0; --j) {
                    temp[combination[j]] = IndicesUtils.createIndex(j, IndicesUtils.getType(metricInds[combination[j]]), true);
                }
                int counter = combination.length;
                for (int j = 0; j < metricInds.length; ++j) {
                    if (temp[j] != -1) continue;
                    temp[j] = IndicesUtils.createIndex(counter++, IndicesUtils.getType(metricInds[j]), false);
                }
                IntArrayList _result = nonMetricIndices.clone();
                _result.addAll(temp);
                Tensor renamed = ApplyIndexMapping.applyIndexMapping(st, new Mapping(indicesArray, _result.toArray()));
                for (Tensor existing : combinationArray) {
                    if (TensorUtils.compare1(existing, renamed) == null) continue;
                    continue block2;
                }
                combinationArray.add(renamed);
            }
            samples.addAll(combinationArray);
        }
        return samples.toArray(new Tensor[samples.size()]);
    }
}

