/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.iterator;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorWrapper;
import cc.redberry.core.tensor.iterator.Payload;
import cc.redberry.core.tensor.iterator.PayloadFactory;
import cc.redberry.core.tensor.iterator.StackPosition;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.tensor.iterator.TraversePermission;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.utils.Indicator;

public final class TreeTraverseIterator<T extends Payload<T>> {
    private final TraverseGuide iterationGuide;
    private LinkedPointer currentPointer;
    private TraverseState lastState;
    private Tensor current = null;
    private final PayloadFactory<T> payloadFactory;

    public TreeTraverseIterator(Tensor tensor, TraverseGuide guide, PayloadFactory<T> payloadFactory) {
        this.currentPointer = new LinkedPointer(null, TensorWrapper.wrap(tensor), true);
        this.iterationGuide = guide;
        this.payloadFactory = payloadFactory;
    }

    public TreeTraverseIterator(Tensor tensor, TraverseGuide guide) {
        this(tensor, guide, null);
    }

    public TreeTraverseIterator(Tensor tensor) {
        this(tensor, TraverseGuide.ALL);
    }

    public TreeTraverseIterator(Tensor tensor, PayloadFactory<T> payloadFactory) {
        this(tensor, TraverseGuide.ALL, payloadFactory);
    }

    public TraverseState next() {
        Tensor next;
        TraversePermission permission;
        if (this.lastState == TraverseState.Leaving) {
            Tensor cur = null;
            if (this.currentPointer.payload != null) {
                cur = this.currentPointer.payload.onLeaving(this.currentPointer);
            }
            if (cur != null) {
                this.current = cur;
            }
            this.currentPointer = this.currentPointer.previous;
            this.currentPointer.set(this.current);
        }
        do {
            if ((next = this.currentPointer.next()) == null) {
                if (this.currentPointer.previous == null) {
                    this.lastState = null;
                    return null;
                }
                this.current = this.currentPointer.getTensor();
                this.lastState = TraverseState.Leaving;
                return this.lastState;
            }
            permission = this.iterationGuide.getPermission(next, this.currentPointer.tensor, this.currentPointer.position - 1);
            if (permission != null) continue;
            throw new NullPointerException();
        } while (permission == TraversePermission.DontShow);
        this.current = next;
        this.currentPointer = new LinkedPointer(this.currentPointer, next, permission == TraversePermission.Enter);
        this.lastState = TraverseState.Entering;
        return this.lastState;
    }

    public void set(Tensor tensor) {
        if (this.current == tensor) {
            return;
        }
        if (tensor == null) {
            throw new NullPointerException();
        }
        this.current = this.currentPointer.tensor = tensor;
        this.lastState = TraverseState.Leaving;
    }

    public int depth() {
        return this.currentPointer.getDepth();
    }

    public boolean isUnder(Indicator<Tensor> indicator, int searchDepth) {
        return this.currentPointer.isUnder(indicator, searchDepth);
    }

    public boolean checkLevel(Indicator<Tensor> indicator, int level) {
        StackPosition s = this.currentPointer.previous(level);
        if (s == null) {
            return false;
        }
        return indicator.is(s.getInitialTensor());
    }

    public Tensor current() {
        return this.current;
    }

    public Tensor result() {
        if (this.currentPointer.previous != null) {
            throw new RuntimeException("Iteration not finished.");
        }
        return this.currentPointer.getTensor().get(0);
    }

    public StackPosition<T> currentStackPosition() {
        return this.currentPointer;
    }

    private final class LinkedPointer
    implements StackPosition<T> {
        int position = 0;
        Tensor tensor;
        Tensor current = null;
        Tensor toSet = null;
        TensorBuilder builder = null;
        final LinkedPointer previous;
        boolean isModified = false;
        T payload = null;

        public LinkedPointer(LinkedPointer pair, Tensor tensor, boolean goInside) {
            this.tensor = tensor;
            if (!goInside) {
                this.position = Integer.MAX_VALUE;
            }
            this.previous = pair;
            if (this.previous != null && TreeTraverseIterator.this.payloadFactory != null && !TreeTraverseIterator.this.payloadFactory.allowLazyInitialization()) {
                this.payload = TreeTraverseIterator.this.payloadFactory.create(this);
                if (this.payload == null) {
                    throw new NullPointerException("Payload factory returned null payload.");
                }
            }
        }

        Tensor next() {
            if (this.toSet != null) {
                if (this.builder == null) {
                    this.builder = this.tensor.getBuilder();
                    for (int i = 0; i < this.position - 1; ++i) {
                        this.builder.put(this.tensor.get(i));
                    }
                }
                this.builder.put(this.toSet);
                this.toSet = null;
            } else if (this.builder != null) {
                this.builder.put(this.current);
            }
            if (this.position >= this.tensor.size()) {
                this.current = null;
                return null;
            }
            this.current = this.tensor.get(this.position++);
            return this.current;
        }

        @Override
        public Tensor getTensor() {
            if (this.builder != null) {
                if (this.position != this.tensor.size()) {
                    throw new IllegalStateException("Iteration not finished.");
                }
                this.tensor = this.builder.build();
                this.position = Integer.MAX_VALUE;
                this.builder = null;
            }
            return this.tensor;
        }

        @Override
        public Tensor getInitialTensor() {
            if (this.position == Integer.MAX_VALUE) {
                throw new IllegalStateException("Initial tensor was rebuilt.");
            }
            return this.tensor;
        }

        @Override
        public boolean isModified() {
            return this.isModified;
        }

        @Override
        public StackPosition previous() {
            if (this.previous.previous == null) {
                return null;
            }
            return this.previous;
        }

        @Override
        public T getPayload() {
            if (TreeTraverseIterator.this.payloadFactory == null || this.previous == null) {
                return null;
            }
            if (this.payload == null) {
                this.payload = TreeTraverseIterator.this.payloadFactory.create(this);
                if (this.payload == null) {
                    throw new NullPointerException("Payload factory returned null payload.");
                }
            }
            return this.payload;
        }

        @Override
        public boolean isPayloadInitialized() {
            return this.payload != null;
        }

        void setModified() {
            this.isModified = true;
            if (this.previous != null) {
                this.previous.setModified();
            }
        }

        void set(Tensor t) {
            if (this.current == t) {
                return;
            }
            this.toSet = t;
            this.setModified();
        }

        @Override
        public int getDepth() {
            int depth = -2;
            LinkedPointer pointer = this;
            while (pointer != null) {
                pointer = pointer.previous;
                ++depth;
            }
            return depth;
        }

        @Override
        public boolean isUnder(Indicator<Tensor> indicator, int searchDepth) {
            LinkedPointer pointer = this;
            do {
                if (!indicator.is(pointer.tensor)) continue;
                return true;
            } while ((pointer = pointer.previous) != null && searchDepth-- > 0);
            return false;
        }

        @Override
        public StackPosition<T> previous(int level) {
            LinkedPointer pointer = this;
            while (pointer != null && level-- > 0) {
                pointer = pointer.previous;
            }
            return pointer;
        }

        @Override
        public int currentIndex() {
            return this.position - 1;
        }
    }
}

