/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorException;
import cc.redberry.core.utils.TensorUtils;

public abstract class ScalarFunction
extends Tensor {
    protected final Tensor argument;

    protected ScalarFunction(Tensor argument) {
        if (!TensorUtils.isScalar(argument)) {
            throw new TensorException("Non scalar argument " + argument + " in scalar function");
        }
        this.argument = argument;
    }

    @Override
    public final Indices getIndices() {
        return IndicesFactory.EMPTY_INDICES;
    }

    protected abstract String functionName();

    public abstract Tensor derivative();

    @Override
    public final Tensor get(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.argument;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final String toString(OutputFormat mode) {
        String stringSymbol = this.functionName();
        if (mode.is(OutputFormat.UTF8)) {
            return stringSymbol + "(" + this.argument.toString(OutputFormat.UTF8) + ")";
        }
        if (mode.is(OutputFormat.LaTeX)) {
            return "\\" + stringSymbol.toLowerCase() + "(" + this.argument.toString(OutputFormat.UTF8) + ")";
        }
        if (mode.is(OutputFormat.Redberry)) {
            return Character.toString(Character.toUpperCase(stringSymbol.charAt(0))) + stringSymbol.substring(1, stringSymbol.length()) + "[" + this.argument.toString(OutputFormat.Redberry) + "]";
        }
        return stringSymbol + "(" + this.argument.toString(OutputFormat.UTF8) + ")";
    }
}

