/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ArcCos;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.tensor.functions.Sin;
import cc.redberry.core.utils.TensorUtils;

public final class Cos
extends ScalarFunction {
    Cos(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.multiply(Complex.MINUS_ONE, new Sin(this.argument));
    }

    @Override
    protected int hash() {
        return 11 * this.argument.hashCode();
    }

    @Override
    public String functionName() {
        return "Cos";
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(CosFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return CosFactory.FACTORY;
    }

    public static final class CosFactory
    extends ScalarFunctionFactory {
        public static final CosFactory FACTORY = new CosFactory();

        private CosFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof ArcCos) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Complex.ONE;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.cos((Complex)arg);
            }
            return new Cos(arg);
        }
    }
}

