/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.tensor.functions.Sin;
import cc.redberry.core.utils.TensorUtils;

public class ArcSin
extends ScalarFunction {
    ArcSin(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.pow(Tensors.sum(Complex.ONE, Tensors.pow(this.argument, Complex.TWO)), Complex.MINUS_ONE_HALF);
    }

    @Override
    protected String functionName() {
        return "ArcSin";
    }

    @Override
    protected int hash() {
        return 92837 * this.argument.hashCode();
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(ArcSinFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return new ArcSinFactory();
    }

    public static final class ArcSinFactory
    extends ScalarFunctionFactory {
        public static final ArcSinFactory FACTORY = new ArcSinFactory();

        private ArcSinFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof Sin) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Complex.ZERO;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.arcsin((Complex)arg);
            }
            return new ArcSin(arg);
        }
    }
}

