/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.context.NameDescriptorForSimpleTensor;
import cc.redberry.core.context.NameDescriptorForTensorField;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.SimpleIndicesBuilder;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.indices.UnsafeIndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseTokenTransformer;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.ExpressionFactory;
import cc.redberry.core.tensor.MultiTensor;
import cc.redberry.core.tensor.PowerBuilder;
import cc.redberry.core.tensor.ProductFactory;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.SumFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.functions.ArcCos;
import cc.redberry.core.tensor.functions.ArcCot;
import cc.redberry.core.tensor.functions.ArcSin;
import cc.redberry.core.tensor.functions.ArcTan;
import cc.redberry.core.tensor.functions.Cos;
import cc.redberry.core.tensor.functions.Cot;
import cc.redberry.core.tensor.functions.Exp;
import cc.redberry.core.tensor.functions.Log;
import cc.redberry.core.tensor.functions.Sin;
import cc.redberry.core.tensor.functions.Tan;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

public final class Tensors {
    private Tensors() {
    }

    public static Tensor pow(Tensor argument, int power) {
        return Tensors.pow(argument, new Complex(power));
    }

    public static Tensor pow(Tensor argument, BigInteger power) {
        return Tensors.pow(argument, new Complex(power));
    }

    public static Tensor pow(Tensor argument, Tensor power) {
        PowerBuilder pb = new PowerBuilder();
        pb.put(argument);
        pb.put(power);
        return pb.build();
    }

    public static Tensor multiply(Tensor ... factors) {
        return ProductFactory.FACTORY.create(factors);
    }

    public static Tensor multiply(Collection<Tensor> factors) {
        return Tensors.multiply(factors.toArray(new Tensor[factors.size()]));
    }

    public static Tensor multiplyAndRenameConflictingDummies(Tensor ... factors) {
        return ProductFactory.FACTORY.create(Tensors.resolveDummy(factors));
    }

    public static Tensor multiplyAndRenameConflictingDummies(Collection<Tensor> factors) {
        return Tensors.multiplyAndRenameConflictingDummies(factors.toArray(new Tensor[factors.size()]));
    }

    public static Tensor[] resolveDummy(Tensor[] factors) {
        int i;
        Tensor[] result = new Tensor[factors.length];
        TIntHashSet forbidden = new TIntHashSet();
        ArrayList<Tensor> toResolve = new ArrayList<Tensor>();
        for (i = factors.length - 1; i >= 0; --i) {
            Tensor f = factors[i];
            if (f instanceof MultiTensor || f.getIndices().getFree().size() == 0) {
                toResolve.add(f);
                forbidden.addAll(IndicesUtils.getIndicesNames(f.getIndices().getFree()));
                continue;
            }
            forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(f));
            result[i] = f;
        }
        int toResolvePosition = toResolve.size();
        for (i = factors.length - 1; i >= 0; --i) {
            if (result[i] != null) continue;
            Tensor factor = (Tensor)toResolve.get(--toResolvePosition);
            Tensor newFactor = ApplyIndexMapping.renameDummy(factor, forbidden.toArray());
            forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(newFactor));
            result[i] = newFactor;
        }
        return result;
    }

    public static void resolveAllDummies(Tensor[] factors) {
        int i;
        TIntHashSet forbidden = new TIntHashSet();
        for (i = factors.length - 1; i >= 0; --i) {
            forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(factors[i]));
        }
        for (i = factors.length - 1; i >= 0; --i) {
            factors[i] = ApplyIndexMapping.renameDummy(factors[i], forbidden.toArray());
            forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(factors[i]));
        }
    }

    public static Tensor divide(Tensor a, Tensor b) {
        return Tensors.multiply(a, Tensors.reciprocal(b));
    }

    public static Tensor sum(Tensor ... tensors) {
        return SumFactory.FACTORY.create(tensors);
    }

    public static Tensor sum(Collection<Tensor> tensors) {
        return Tensors.sum(tensors.toArray(new Tensor[tensors.size()]));
    }

    public static Tensor subtract(Tensor a, Tensor b) {
        return Tensors.sum(a, Tensors.negate(b));
    }

    public static Tensor negate(Tensor tensor) {
        if (tensor instanceof Complex) {
            return ((Complex)tensor).negate();
        }
        return Tensors.multiply(Complex.MINUS_ONE, tensor);
    }

    public static Tensor reciprocal(Tensor tensor) {
        return Tensors.pow(tensor, Complex.MINUS_ONE);
    }

    public static SimpleTensor simpleTensor(String name, SimpleIndices indices) {
        NameDescriptor descriptor = CC.getNameManager().mapNameDescriptor(name, indices.getStructureOfIndices());
        if (indices.size() == 0) {
            assert (indices == IndicesFactory.EMPTY_SIMPLE_INDICES);
            NameDescriptorForSimpleTensor nst = (NameDescriptorForSimpleTensor)descriptor;
            if (nst.getCachedSymbol() == null) {
                SimpleTensor st = new SimpleTensor(descriptor.getId(), indices);
                nst.setCachedInstance(st);
                return st;
            }
            return nst.getCachedSymbol();
        }
        return new SimpleTensor(descriptor.getId(), UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices));
    }

    public static SimpleTensor simpleTensor(int name, SimpleIndices indices) {
        NameDescriptor descriptor = CC.getNameDescriptor(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("This name is not registered in the system.");
        }
        if (!descriptor.getStructureOfIndices().isStructureOf(indices)) {
            throw new IllegalArgumentException("Specified indices ( " + indices + " )are not indices of specified tensor ( " + descriptor + " ).");
        }
        if (indices.size() == 0) {
            assert (indices == IndicesFactory.EMPTY_SIMPLE_INDICES);
            NameDescriptorForSimpleTensor nst = (NameDescriptorForSimpleTensor)descriptor;
            if (nst.getCachedSymbol() == null) {
                SimpleTensor st = new SimpleTensor(descriptor.getId(), indices);
                nst.setCachedInstance(st);
                return st;
            }
            return nst.getCachedSymbol();
        }
        return new SimpleTensor(name, UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices));
    }

    public static TensorField fieldDerivative(TensorField parent, SimpleIndices derivativeIndices, int argPosition) {
        return Tensors.fieldDerivative(parent, derivativeIndices, argPosition, 1);
    }

    public static TensorField fieldDerivative(TensorField parent, SimpleIndices derivativeIndices, int argPosition, int order) {
        SimpleIndices totalIndices;
        if (!derivativeIndices.getStructureOfIndices().equals(parent.argIndices[argPosition].getInverted().getStructureOfIndices().pow(order))) {
            throw new IllegalArgumentException("Illegal derivative indices.");
        }
        int[] orders = new int[parent.size()];
        orders[argPosition] = order;
        NameDescriptorForTensorField fieldDescriptor = parent.getNameDescriptor();
        NameDescriptorForTensorField derivativeDescriptor = fieldDescriptor.getDerivative(orders);
        if (!fieldDescriptor.isDerivative() || derivativeIndices.size() == 0 || parent.indices.size() == 0) {
            totalIndices = new SimpleIndicesBuilder().append(parent.getIndices()).append(derivativeIndices).getIndices();
        } else {
            orders = fieldDescriptor.getDerivativeOrders();
            SimpleIndicesBuilder ib = new SimpleIndicesBuilder();
            StructureOfIndices[] structures = fieldDescriptor.getStructuresOfIndices();
            for (byte type = 7; type >= 0; type = (byte)(type - 1)) {
                int i;
                IndexType eType = IndexType.values()[type];
                SimpleIndices singleType = parent.getIndices().getOfType(eType);
                int from = fieldDescriptor.getParent().getStructureOfIndices().getTypeData((byte)type).length;
                for (i = 0; i <= argPosition; ++i) {
                    from += structures[i + 1].getTypeData((byte)type).length * orders[i];
                }
                for (i = 0; i < from; ++i) {
                    ib.append(singleType.get(i));
                }
                ib.append(derivativeIndices.getOfType(eType));
                while (i < singleType.size()) {
                    ib.append(singleType.get(i));
                    ++i;
                }
            }
            totalIndices = ib.getIndices();
        }
        return new TensorField(derivativeDescriptor.getId(), UnsafeIndicesFactory.createOfTensor(derivativeDescriptor.getSymmetries(), totalIndices), parent.args, parent.argIndices);
    }

    public static TensorField fieldDerivative(String name, SimpleIndices indices, SimpleIndices[] argIndices, Tensor[] arguments, int[] orders) {
        if (argIndices.length != arguments.length) {
            throw new IllegalArgumentException("Argument indices array and arguments array have different length.");
        }
        if (arguments.length == 0) {
            throw new IllegalArgumentException("No arguments in field.");
        }
        for (int i = 0; i < argIndices.length; ++i) {
            if (arguments[i].getIndices().getFree().equalsRegardlessOrder(argIndices[i])) continue;
            throw new IllegalArgumentException("Arguments indices are inconsistent with arguments.");
        }
        try {
            StructureOfIndices[] structures = new StructureOfIndices[argIndices.length + 1];
            StructureOfIndices structureOfIndices = indices.getStructureOfIndices();
            for (int i = argIndices.length - 1; i >= 0; --i) {
                structures[i + 1] = argIndices[i].getStructureOfIndices();
                for (int j = orders[i]; j > 0; --j) {
                    structureOfIndices = structureOfIndices.subtract(structures[i + 1]);
                }
            }
            structures[0] = structureOfIndices;
            NameDescriptorForTensorField fieldDescriptor = (NameDescriptorForTensorField)CC.getNameManager().mapNameDescriptor(name, structures);
            NameDescriptorForTensorField derivativeDescriptor = fieldDescriptor.getDerivative(orders);
            return new TensorField(derivativeDescriptor.getId(), UnsafeIndicesFactory.createOfTensor(derivativeDescriptor.getSymmetries(), indices), arguments, argIndices);
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("Inconsistent derivative orders/indices.", re);
        }
    }

    public static TensorField field(String name, SimpleIndices indices, Tensor[] arguments) {
        SimpleIndices[] argIndices = new SimpleIndices[arguments.length];
        for (int i = 0; i < argIndices.length; ++i) {
            argIndices[i] = IndicesFactory.createSimple(null, arguments[i].getIndices().getFree());
        }
        return Tensors.field(name, indices, argIndices, arguments);
    }

    public static TensorField field(String name, SimpleIndices indices, Collection<Tensor> arguments) {
        return Tensors.field(name, indices, arguments.toArray(new Tensor[arguments.size()]));
    }

    public static TensorField field(String name, SimpleIndices indices, SimpleIndices[] argIndices, Tensor[] arguments) {
        if (argIndices.length != arguments.length) {
            throw new IllegalArgumentException("Argument indices array and arguments array have different length.");
        }
        if (arguments.length == 0) {
            throw new IllegalArgumentException("No arguments in field.");
        }
        for (int i = 0; i < argIndices.length; ++i) {
            if (arguments[i].getIndices().getFree().equalsRegardlessOrder(argIndices[i])) continue;
            throw new IllegalArgumentException("Arguments indices are inconsistent with arguments.");
        }
        StructureOfIndices[] structures = new StructureOfIndices[argIndices.length + 1];
        structures[0] = indices.getStructureOfIndices();
        for (int i = 0; i < argIndices.length; ++i) {
            structures[i + 1] = argIndices[i].getStructureOfIndices();
        }
        NameDescriptor descriptor = CC.getNameManager().mapNameDescriptor(name, structures);
        return new TensorField(descriptor.getId(), UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices), arguments, argIndices);
    }

    public static TensorField field(int name, SimpleIndices indices, SimpleIndices[] argIndices, Tensor[] arguments) {
        if (argIndices.length != arguments.length) {
            throw new IllegalArgumentException("Argument indices array and arguments array have different length.");
        }
        if (arguments.length == 0) {
            throw new IllegalArgumentException("No arguments in field.");
        }
        NameDescriptor descriptor = CC.getNameDescriptor(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("This name is not registered in the system.");
        }
        if (!descriptor.isField()) {
            throw new IllegalArgumentException("Name correspods to simple tensor (not a field).");
        }
        if (descriptor.getStructuresOfIndices().length - 1 != argIndices.length) {
            throw new IllegalArgumentException("This name corresponds to field with different number of arguments.");
        }
        if (!descriptor.getStructureOfIndices().isStructureOf(indices)) {
            throw new IllegalArgumentException("Specified indices are not indices of specified tensor.");
        }
        for (int i = 0; i < argIndices.length; ++i) {
            if (!descriptor.getStructuresOfIndices()[i + 1].isStructureOf(argIndices[i])) {
                throw new IllegalArgumentException("Arguments indices are inconsistent with field signature.");
            }
            if (arguments[i].getIndices().getFree().equalsRegardlessOrder(argIndices[i])) continue;
            throw new IllegalArgumentException("Arguments indices are inconsistent with arguments.");
        }
        return new TensorField(name, UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices), arguments, argIndices);
    }

    public static TensorField field(int name, SimpleIndices indices, Tensor[] arguments) {
        if (arguments.length == 0) {
            throw new IllegalArgumentException("No arguments in field.");
        }
        NameDescriptor descriptor = CC.getNameDescriptor(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("This name is not registered in the system.");
        }
        if (!descriptor.getStructureOfIndices().isStructureOf(indices)) {
            throw new IllegalArgumentException("Specified indices are not indices of specified tensor.");
        }
        SimpleIndices[] argIndices = new SimpleIndices[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argIndices[i] = IndicesFactory.createSimple(null, arguments[i].getIndices().getFree());
        }
        return new TensorField(name, UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices), arguments, argIndices);
    }

    public static SimpleTensor setIndices(SimpleTensor tensor, int[] indices) {
        return Tensors.setIndices(tensor, IndicesFactory.createSimple(null, indices));
    }

    public static SimpleTensor setIndices(SimpleTensor tensor, SimpleIndices indices) {
        if (tensor.getIndices() == indices) {
            return tensor;
        }
        NameDescriptor descriptor = tensor.getNameDescriptor();
        if (!descriptor.getStructureOfIndices().isStructureOf(indices)) {
            throw new IllegalArgumentException("Illegal structure of indices.");
        }
        if (indices.size() == 0) {
            return tensor;
        }
        if (descriptor.isField()) {
            return new TensorField(tensor.name, UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices), ((TensorField)tensor).args, ((TensorField)tensor).argIndices);
        }
        return new SimpleTensor(tensor.name, UnsafeIndicesFactory.createOfTensor(descriptor.getSymmetries(), indices));
    }

    public static Expression expression(Tensor left, Tensor right) {
        return ExpressionFactory.FACTORY.create(left, right);
    }

    public static Tensor sin(Tensor argument) {
        return Sin.SinFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor cos(Tensor argument) {
        return Cos.CosFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor tan(Tensor argument) {
        return Tan.TanFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor cot(Tensor argument) {
        return Cot.CotFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor arcsin(Tensor argument) {
        return ArcSin.ArcSinFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor arccos(Tensor argument) {
        return ArcCos.ArcCosFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor arctan(Tensor argument) {
        return ArcTan.ArcTanFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor arccot(Tensor argument) {
        return ArcCot.ArcCotFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor log(Tensor argument) {
        return Log.LogFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static Tensor exp(Tensor argument) {
        return Exp.ExpFactory.FACTORY.create(new Tensor[]{argument});
    }

    public static SimpleTensor createKronecker(int index1, int index2) {
        return CC.current().createKronecker(index1, index2);
    }

    public static SimpleTensor createMetric(int index1, int index2) {
        return CC.current().createMetric(index1, index2);
    }

    public static SimpleTensor createMetricOrKronecker(int index1, int index2) {
        return CC.current().createMetricOrKronecker(index1, index2);
    }

    public static boolean isKronecker(Tensor t) {
        if (!(t instanceof SimpleTensor)) {
            return false;
        }
        return CC.current().isKronecker((SimpleTensor)t);
    }

    public static boolean isMetric(Tensor t) {
        if (!(t instanceof SimpleTensor)) {
            return false;
        }
        return CC.current().isMetric((SimpleTensor)t);
    }

    public static boolean isKroneckerOrMetric(Tensor t) {
        if (!(t instanceof SimpleTensor)) {
            return false;
        }
        return CC.current().isKroneckerOrMetric((SimpleTensor)t);
    }

    public static boolean isKroneckerOrMetric(SimpleTensor t) {
        return CC.current().isKroneckerOrMetric(t);
    }

    public static Tensor parse(String expression) {
        return CC.current().getParseManager().parse(expression);
    }

    public static Tensor parse(int i) {
        return new Complex(i);
    }

    public static Tensor parse(long i) {
        return new Complex(i);
    }

    public static Tensor parse(double i) {
        return new Complex(i);
    }

    public static Tensor parse(float i) {
        return new Complex(i);
    }

    public static Tensor[] parse(String ... expressions) {
        Tensor[] r = new Tensor[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            r[i] = Tensors.parse(expressions[i]);
        }
        return r;
    }

    public static Tensor parse(String expression, ParseTokenTransformer ... preprocessors) {
        return CC.current().getParseManager().parse(expression, preprocessors);
    }

    public static SimpleTensor parseSimple(String expression) {
        Tensor t = Tensors.parse(expression);
        if (!(t instanceof SimpleTensor)) {
            throw new IllegalArgumentException("Input tensor is not SimpleTensor.");
        }
        return (SimpleTensor)t;
    }

    public static Expression parseExpression(String expression) {
        Tensor t = Tensors.parse(expression);
        if (!(t instanceof Expression)) {
            throw new IllegalArgumentException("Input tensor is not Expression.");
        }
        return (Expression)t;
    }

    public static void addSymmetry(String tensor, IndexType type, Permutation permutation) {
        Tensors.addSymmetry(Tensors.parseSimple(tensor), type, permutation);
    }

    public static void addSymmetry(SimpleTensor tensor, IndexType type, Permutation permutation) {
        tensor.getIndices().getSymmetries().addSymmetry(type.getType(), permutation);
    }

    public static void addSymmetry(SimpleTensor tensor, Permutation permutation) {
        tensor.getIndices().getSymmetries().addSymmetry(permutation);
    }

    public static void addSymmetry(String tensor, Permutation permutation) {
        Tensors.addSymmetry(Tensors.parseSimple(tensor), permutation);
    }

    public static void addSymmetries(SimpleTensor tensor, Permutation ... permutations) {
        for (Permutation p : permutations) {
            tensor.getIndices().getSymmetries().addSymmetry(p);
        }
    }

    public static void addSymmetries(String tensor, Permutation ... permutations) {
        Tensors.addSymmetries(Tensors.parseSimple(tensor), permutations);
    }

    public static void addSymmetry(String tensor, IndexType type, boolean sign, int ... permutation) {
        Tensors.parseSimple(tensor).getIndices().getSymmetries().add(type.getType(), sign, permutation);
    }

    public static void addSymmetry(SimpleTensor tensor, IndexType type, boolean sign, int ... permutation) {
        tensor.getIndices().getSymmetries().add(type.getType(), sign, permutation);
    }

    public static void addSymmetry(String tensor, IndexType type, int ... permutation) {
        Tensors.addSymmetry(tensor, type, false, permutation);
    }

    public static void addSymmetry(SimpleTensor tensor, IndexType type, int ... permutation) {
        Tensors.addSymmetry(tensor, type, false, permutation);
    }

    public static void addAntiSymmetry(String tensor, IndexType type, int ... permutation) {
        Tensors.addSymmetry(tensor, type, true, permutation);
    }

    public static void addAntiSymmetry(SimpleTensor tensor, IndexType type, int ... permutation) {
        Tensors.addSymmetry(tensor, type, true, permutation);
    }

    public static void addSymmetry(String tensor, int ... permutation) {
        Tensors.parseSimple(tensor).getIndices().getSymmetries().addSymmetry(permutation);
    }

    public static void addSymmetry(SimpleTensor tensor, int ... permutation) {
        tensor.getIndices().getSymmetries().addSymmetry(permutation);
    }

    public static void addAntiSymmetry(String tensor, int ... permutation) {
        Tensors.parseSimple(tensor).getIndices().getSymmetries().addAntiSymmetry(permutation);
    }

    public static void addAntiSymmetry(SimpleTensor tensor, int ... permutation) {
        tensor.getIndices().getSymmetries().addAntiSymmetry(permutation);
    }

    public static void setAntiSymmetric(SimpleTensor tensor, IndexType type) {
        int dimension = tensor.getIndices().size(type);
        Tensors.addSymmetry(tensor, type, true, Permutations.createTransposition(dimension));
        if (dimension > 2) {
            tensor.getIndices().getSymmetries().addSymmetry(type.getType(), Permutations.createPermutation(dimension % 2 == 0, Permutations.createCycle(dimension)));
        }
    }

    public static void setAntiSymmetric(SimpleTensor tensor) {
        tensor.getIndices().getSymmetries().setAntiSymmetric();
    }

    public static void setAntiSymmetric(String tensor) {
        Tensors.setAntiSymmetric(Tensors.parseSimple(tensor));
    }

    public static void setAntiSymmetric(Object ... tensors) {
        for (Object tensor : tensors) {
            if (tensor instanceof SimpleTensor) {
                Tensors.setAntiSymmetric((SimpleTensor)tensor);
                continue;
            }
            if (tensor instanceof String) {
                Tensors.setAntiSymmetric((String)tensor);
                continue;
            }
            throw new IllegalArgumentException("Not a tensor " + tensor);
        }
    }

    public static void setSymmetric(SimpleTensor tensor, IndexType type) {
        int dimension = tensor.getIndices().size(type);
        tensor.getIndices().getSymmetries().addSymmetry(type, Permutations.createCycle(dimension));
        tensor.getIndices().getSymmetries().addSymmetry(type, Permutations.createTransposition(dimension));
    }

    public static void setSymmetric(SimpleTensor tensor) {
        tensor.getIndices().getSymmetries().setSymmetric();
    }

    public static void setSymmetric(String tensor) {
        Tensors.setSymmetric(Tensors.parseSimple(tensor));
    }

    public static void setSymmetric(Object ... tensors) {
        for (Object tensor : tensors) {
            if (tensor instanceof SimpleTensor) {
                Tensors.setSymmetric((SimpleTensor)tensor);
                continue;
            }
            if (tensor instanceof String) {
                Tensors.setSymmetric((String)tensor);
                continue;
            }
            throw new IllegalArgumentException("Not a tensor " + tensor);
        }
    }

    public static void setAntiSymmetric(String ... tensors) {
        for (String tensor : tensors) {
            Tensors.setAntiSymmetric(tensor);
        }
    }
}

