/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorException;
import cc.redberry.core.tensor.TensorFactory;

public final class TensorWrapper
extends Tensor {
    private final Tensor innerTensor;

    private TensorWrapper(Tensor innerTensor) {
        this.innerTensor = innerTensor;
    }

    @Override
    public Tensor get(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.innerTensor;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public TensorBuilder getBuilder() {
        return new Builder();
    }

    @Override
    public TensorFactory getFactory() {
        return Factory.FACTORY;
    }

    public static TensorWrapper wrap(Tensor tensor) {
        return new TensorWrapper(tensor);
    }

    @Override
    public Indices getIndices() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected int hash() {
        return -1;
    }

    @Override
    public String toString(OutputFormat mode) {
        return "@[" + this.innerTensor.toString(mode) + "]";
    }

    private static final class Factory
    implements TensorFactory {
        private static final Factory FACTORY = new Factory();

        private Factory() {
        }

        @Override
        public Tensor create(Tensor ... tensors) {
            if (tensors.length != 1) {
                throw new IllegalArgumentException();
            }
            if (tensors[0] == null) {
                throw new NullPointerException();
            }
            return new TensorWrapper(tensors[0]);
        }
    }

    private static final class Builder
    implements TensorBuilder {
        private Tensor innerTensor;

        Builder() {
        }

        Builder(Tensor innerTensor) {
            this.innerTensor = innerTensor;
        }

        @Override
        public Tensor build() {
            if (this.innerTensor == null) {
                throw new IllegalStateException("No elements added.");
            }
            return new TensorWrapper(this.innerTensor);
        }

        @Override
        public void put(Tensor tensor) {
            if (tensor == null) {
                throw new NullPointerException();
            }
            if (this.innerTensor != null) {
                throw new TensorException("Wrapper have only one element!");
            }
            this.innerTensor = tensor;
        }

        @Override
        public TensorBuilder clone() {
            return new Builder(this.innerTensor);
        }
    }
}

