/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.NameDescriptorForTensorField;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.SimpleIndicesBuilder;
import cc.redberry.core.tensor.BasicTensorIterator;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import java.util.Arrays;
import java.util.Iterator;

public final class TensorField
extends SimpleTensor {
    protected Tensor[] args;
    protected SimpleIndices[] argIndices;

    TensorField(int name, SimpleIndices indices, Tensor[] args, SimpleIndices[] argIndices) {
        super(name, indices);
        this.args = args;
        this.argIndices = argIndices;
    }

    TensorField(TensorField field, Tensor[] args) {
        super(field.name, field.indices);
        this.args = args;
        this.argIndices = field.argIndices;
    }

    public Tensor[] getArguments() {
        return (Tensor[])this.args.clone();
    }

    public SimpleIndices[] getArgIndices() {
        return (SimpleIndices[])this.argIndices.clone();
    }

    public SimpleIndices getArgIndices(int i) {
        return this.argIndices[i];
    }

    public boolean isDerivative() {
        return this.getNameDescriptor().isDerivative();
    }

    @Override
    public Tensor get(int i) {
        return this.args[i];
    }

    @Override
    public int size() {
        return this.args.length;
    }

    @Override
    public Iterator<Tensor> iterator() {
        return new BasicTensorIterator(this);
    }

    @Override
    public Tensor[] getRange(int from, int to) {
        return Arrays.copyOfRange(this.args, from, to);
    }

    @Override
    public NameDescriptorForTensorField getNameDescriptor() {
        return (NameDescriptorForTensorField)super.getNameDescriptor();
    }

    public TensorField getParentField() {
        if (!this.isDerivative()) {
            return this;
        }
        return Tensors.field(this.getNameDescriptor().getParent().getId(), this.getPartitionOfIndices()[0][0], this.args);
    }

    public int getDeivativeOrder(int i) {
        return this.getNameDescriptor().getDerivativeOrder(i);
    }

    public SimpleIndices[][] getPartitionOfIndices() {
        NameDescriptorForTensorField fieldDescriptor = this.getNameDescriptor();
        if (!fieldDescriptor.isDerivative()) {
            SimpleIndices[][] ret = new SimpleIndices[this.args.length + 1][];
            Arrays.fill((Object[])ret, 1, ret.length, new SimpleIndices[0]);
            ret[0] = new SimpleIndices[]{this.indices};
            return ret;
        }
        int[] orders = fieldDescriptor.getDerivativeOrders();
        int[][] _mapping = fieldDescriptor.getIndicesPartitionMapping();
        SimpleIndices[][] iPartition = new SimpleIndices[this.args.length + 1][];
        int totalOrder = 0;
        for (int i = 0; i <= this.args.length; ++i) {
            int l = i == 0 ? 1 : orders[i - 1];
            iPartition[i] = new SimpleIndices[l];
            for (int j = 0; j < l; ++j) {
                int[] _map = _mapping[totalOrder++];
                SimpleIndicesBuilder ib = new SimpleIndicesBuilder(_map.length);
                int m = _map.length;
                for (int k = 0; k < m; ++k) {
                    ib.append(this.indices.get(_map[k]));
                }
                iPartition[i][j] = ib.getIndices();
            }
        }
        return iPartition;
    }

    @Override
    public String toString0(OutputFormat mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString0(mode));
        if (mode.is(OutputFormat.Maple)) {
            sb.append('(');
        } else {
            sb.append('[');
        }
        for (Tensor t : this.args) {
            sb.append(t.toString(mode));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        if (mode.is(OutputFormat.Maple)) {
            sb.append(')');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public TensorBuilder getBuilder() {
        return new Builder(this);
    }

    @Override
    public TensorFactory getFactory() {
        return new Factory(this);
    }

    private static final class Factory
    implements TensorFactory {
        private final TensorField field;

        public Factory(TensorField field) {
            this.field = field;
        }

        @Override
        public Tensor create(Tensor ... tensors) {
            if (tensors.length != this.field.size()) {
                throw new IllegalArgumentException("Wrong arguments count.");
            }
            for (int i = tensors.length - 1; i >= 0; --i) {
                if (tensors[i] == null) {
                    throw new NullPointerException();
                }
                if (tensors[i].getIndices().getFree().equalsRegardlessOrder(this.field.getArgIndices(i))) continue;
                throw new IllegalArgumentException("Free indices of puted tensor differs from field argument binding indices!");
            }
            return new TensorField(this.field, tensors);
        }
    }

    private static final class Builder
    implements TensorBuilder {
        private final TensorField field;
        private int pointer = 0;
        private final Tensor[] data;

        public Builder(TensorField field) {
            this.field = field;
            this.data = new Tensor[field.size()];
        }

        Builder(TensorField field, Tensor[] data, int pointer) {
            this.field = field;
            this.data = data;
        }

        @Override
        public Tensor build() {
            if (this.pointer != this.data.length) {
                throw new IllegalStateException("Tensor field not fully constructed.");
            }
            return new TensorField(this.field, this.data);
        }

        @Override
        public void put(Tensor tensor) {
            if (this.pointer == this.data.length) {
                throw new IllegalStateException("No more arguments in field.");
            }
            if (tensor == null) {
                throw new NullPointerException();
            }
            if (!tensor.getIndices().getFree().equalsRegardlessOrder(this.field.getArgIndices(this.pointer))) {
                throw new IllegalArgumentException("Free indices of puted tensor differs from field argument binding indices!");
            }
            this.data[this.pointer++] = tensor;
        }

        @Override
        public TensorBuilder clone() {
            return new Builder(this.field, (Tensor[])this.data.clone(), this.pointer);
        }
    }
}

