/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.Context;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.tensor.BasicTensorIterator;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import java.util.Iterator;

public abstract class Tensor
implements Comparable<Tensor>,
Iterable<Tensor> {
    protected abstract int hash();

    public abstract Indices getIndices();

    @Override
    public Iterator<Tensor> iterator() {
        return new BasicTensorIterator(this);
    }

    public abstract Tensor get(int var1);

    public abstract int size();

    public Tensor set(int i, Tensor tensor) {
        int size = this.size();
        if (i >= size || i < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (tensor == null) {
            throw new NullPointerException();
        }
        TensorBuilder builder = this.getBuilder();
        for (int j = 0; j < size; ++j) {
            if (j == i) {
                builder.put(tensor);
                continue;
            }
            builder.put(this.get(j));
        }
        return builder.build();
    }

    public Tensor[] getRange(int from, int to) {
        int size = this.size();
        if (from < 0 || from > to || to > size) {
            throw new IndexOutOfBoundsException();
        }
        Tensor[] range = new Tensor[to - from];
        size = 0;
        while (from < to) {
            range[size] = this.get(from);
            ++size;
            ++from;
        }
        return range;
    }

    public Tensor[] toArray() {
        return this.getRange(0, this.size());
    }

    public abstract String toString(OutputFormat var1);

    public final String toString() {
        return this.toString(Context.get().getDefaultOutputFormat());
    }

    protected String toString(OutputFormat mode, Class<? extends Tensor> clazz) {
        return this.toString(mode);
    }

    @Override
    public final int compareTo(Tensor t) {
        return Integer.compare(this.hash(), t.hash());
    }

    public final int hashCode() {
        return this.hash();
    }

    public abstract TensorBuilder getBuilder();

    public abstract TensorFactory getFactory();
}

