/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.PowersContainer;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.ToNumericTransformation;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import java.util.Arrays;

public final class ProductBuilder
implements TensorBuilder {
    private Complex factor = Complex.ONE;
    private final ArrayList<Tensor> elements;
    private final ArrayList<Tensor> indexLess;
    private final PowersContainer symbolicPowers;

    public ProductBuilder(int initialCapacityIndexless, int initialCapacityData) {
        this.elements = new ArrayList(initialCapacityData);
        this.symbolicPowers = new PowersContainer(initialCapacityIndexless);
        this.indexLess = new ArrayList();
    }

    public ProductBuilder() {
        this(4, 3);
    }

    private ProductBuilder(Complex factor, ArrayList<Tensor> elements, ArrayList<Tensor> indexLess, PowersContainer powers) {
        this.factor = factor;
        this.elements = elements;
        this.indexLess = indexLess;
        this.symbolicPowers = powers;
    }

    private void initializeData(Complex complex, Tensor[] indexlessData, Tensor[] data) {
        this.factor = complex.multiply(this.factor);
        if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
            return;
        }
        this.elements.addAll(Arrays.asList(data));
        for (Tensor t : indexlessData) {
            if (TensorUtils.isSymbolic(t)) {
                Tensor exponent;
                Tensor base;
                if (t instanceof Power) {
                    base = t.get(0);
                    exponent = t.get(1);
                } else {
                    base = t;
                    exponent = Complex.ONE;
                }
                this.symbolicPowers.putNew(base, exponent);
                continue;
            }
            this.indexLess.add(t);
        }
    }

    private boolean isEmpty() {
        return this.symbolicPowers.isEmpty() && this.elements.isEmpty();
    }

    @Override
    public Tensor build() {
        if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
            return this.factor;
        }
        boolean isNumeric = this.factor.isNumeric();
        for (Object t : this.symbolicPowers) {
            if (isNumeric) {
                t = ToNumericTransformation.toNumeric((Tensor)t);
            }
            if (t instanceof Product) {
                this.factor = this.factor.multiply(((Product)t).factor);
                if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
                    return this.factor;
                }
                this.indexLess.ensureCapacity(((Tensor)t).size());
                for (Tensor multiplier : ((Product)t).indexlessData) {
                    this.indexLess.add(multiplier);
                }
                continue;
            }
            if (t instanceof Complex) {
                this.factor = this.factor.multiply((Complex)t);
                if (!NumberUtils.isZeroOrIndeterminate(this.factor)) continue;
                return this.factor;
            }
            this.indexLess.add((Tensor)t);
        }
        if (this.symbolicPowers.isSign()) {
            this.factor = this.factor.negate();
        }
        if (this.indexLess.isEmpty() && this.elements.isEmpty()) {
            return this.factor;
        }
        if (isNumeric) {
            ArrayList<Tensor> nonNumbers = new ArrayList<Tensor>();
            for (Tensor t : this.elements) {
                if ((t = ToNumericTransformation.toNumeric(t)) instanceof Complex) {
                    this.factor = this.factor.multiply((Complex)t);
                    continue;
                }
                nonNumbers.add(t);
            }
            if (this.indexLess.isEmpty() && nonNumbers.isEmpty()) {
                return this.factor;
            }
            this.elements.clear();
            this.elements.addAll(nonNumbers);
        }
        if (this.factor.isOne()) {
            if (this.indexLess.size() == 1 && this.elements.isEmpty()) {
                return this.indexLess.get(0);
            }
            if (this.indexLess.isEmpty() && this.elements.size() == 1) {
                return this.elements.get(0);
            }
        }
        if (this.factor.isMinusOne()) {
            Sum s = null;
            if (this.indexLess.size() == 1 && this.elements.isEmpty() && this.indexLess.get(0) instanceof Sum) {
                s = (Sum)this.indexLess.get(0);
            }
            if (this.indexLess.isEmpty() && this.elements.size() == 1 && this.elements.get(0) instanceof Sum) {
                s = (Sum)this.elements.get(0);
            }
            if (s != null) {
                Tensor[] sumData = (Tensor[])s.data.clone();
                for (int i = sumData.length - 1; i >= 0; --i) {
                    sumData[i] = Tensors.negate(sumData[i]);
                }
                return new Sum(s.indices, sumData, s.hashCode());
            }
        }
        IndicesBuilder ibs = new IndicesBuilder();
        for (Tensor m : this.elements) {
            ibs.append(m);
        }
        return new Product(ibs.getIndices(), this.factor, this.indexLess.toArray(new Tensor[this.indexLess.size()]), this.elements.toArray(new Tensor[this.elements.size()]));
    }

    @Override
    public void put(Tensor tensor) {
        if (this.factor.isNumeric()) {
            tensor = ToNumericTransformation.toNumeric(tensor);
        }
        if (tensor instanceof Complex) {
            this.factor = this.factor.multiply((Complex)tensor);
            return;
        }
        if (tensor instanceof Product) {
            Product p = (Product)tensor;
            if (this.isEmpty()) {
                this.initializeData(p.factor, p.indexlessData, p.data);
            } else {
                this.factor = this.factor.multiply(p.factor);
                if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
                    return;
                }
                for (Tensor t : p.indexlessData) {
                    this.put(t);
                }
                this.elements.addAll(Arrays.asList(p.data));
            }
            return;
        }
        if (NumberUtils.isZeroOrIndeterminate(this.factor)) {
            return;
        }
        if (TensorUtils.isSymbolic(tensor)) {
            this.symbolicPowers.put(tensor);
        } else if (tensor.getIndices().size() == 0) {
            this.indexLess.add(tensor);
        } else {
            this.elements.add(tensor);
        }
    }

    @Override
    public ProductBuilder clone() {
        return new ProductBuilder(this.factor, new ArrayList<Tensor>(this.elements), new ArrayList<Tensor>(this.indexLess), this.symbolicPowers.clone());
    }
}

