/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Exponentiation;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.TensorUtils;

public final class PowerFactory
implements TensorFactory {
    public static final PowerFactory FACTORY = new PowerFactory();

    private PowerFactory() {
    }

    @Override
    public Tensor create(Tensor ... tensors) {
        PowerFactory.checkWithException(tensors);
        return PowerFactory.power(tensors[0], tensors[1]);
    }

    static Tensor power(Tensor argument, Tensor power) {
        Tensor[] scalars;
        Complex p;
        Complex a;
        Complex result;
        if (argument instanceof Complex && power instanceof Complex && (result = Exponentiation.exponentiateIfPossible(a = (Complex)argument, p = (Complex)power)) != null) {
            return result;
        }
        if (TensorUtils.isOne(power)) {
            return argument;
        }
        if (TensorUtils.isZero(power) || TensorUtils.isOne(argument)) {
            return Complex.ONE;
        }
        if (TensorUtils.isZero(argument)) {
            return Complex.ZERO;
        }
        if (argument instanceof Product && (TensorUtils.isInteger(power) || argument.size() == 2 && TensorUtils.isRealPositiveNumber(argument.get(0))) && (scalars = ((Product)argument).getAllScalars()).length > 1) {
            TensorBuilder pb = argument.getBuilder();
            for (Tensor t : scalars) {
                pb.put(Tensors.pow(t, power));
            }
            return pb.build();
        }
        if (argument instanceof Power) {
            return Tensors.pow(argument.get(0), Tensors.multiply(argument.get(1), power));
        }
        return new Power(argument, power);
    }

    private static void checkWithException(Tensor[] tensors) {
        if (tensors.length != 2) {
            throw new IllegalArgumentException("Wrong number of arguments.");
        }
        if (!TensorUtils.isScalar(tensors)) {
            throw new IllegalArgumentException("Non scalar power parametres.");
        }
        for (Tensor t : tensors) {
            if (t != null) continue;
            throw new NullPointerException();
        }
    }
}

