/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.tensor.PowerFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.utils.TensorUtils;

public final class PowerBuilder
implements TensorBuilder {
    private Tensor argument;
    private Tensor power;

    public PowerBuilder() {
    }

    private PowerBuilder(Tensor argument, Tensor power) {
        this.argument = argument;
        this.power = power;
    }

    @Override
    public Tensor build() {
        if (this.power == null) {
            throw new IllegalStateException("Power is not fully constructed.");
        }
        return PowerFactory.power(this.argument, this.power);
    }

    @Override
    public void put(Tensor tensor) {
        if (tensor == null) {
            throw new NullPointerException();
        }
        if (!TensorUtils.isScalar(tensor)) {
            throw new IllegalArgumentException("Non-scalar tensor on input of Power builder.");
        }
        if (this.argument == null) {
            this.argument = tensor;
        } else if (this.power == null) {
            this.power = tensor;
        } else {
            throw new IllegalStateException("Power buider can not take more than two put() invocations.");
        }
    }

    @Override
    public TensorBuilder clone() {
        return new PowerBuilder(this.argument, this.power);
    }
}

