/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.FactorNode;
import cc.redberry.core.tensor.Split;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorException;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.ToNumericTransformation;
import cc.redberry.core.utils.TensorHashCalculator;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSumBuilder
implements TensorBuilder {
    final TIntObjectHashMap<List<FactorNode>> summands;
    Complex complex = Complex.ZERO;
    Indices indices = null;
    int[] sortedFreeIndices;

    public AbstractSumBuilder() {
        this(7);
    }

    public AbstractSumBuilder(int initialCapacity) {
        this.summands = new TIntObjectHashMap(initialCapacity);
    }

    AbstractSumBuilder(TIntObjectHashMap<List<FactorNode>> summands, Complex complex, Indices indices, int[] sortedFreeIndices) {
        this.summands = summands;
        this.complex = complex;
        this.indices = indices;
        this.sortedFreeIndices = sortedFreeIndices;
    }

    @Override
    public Tensor build() {
        if (this.complex.isNaN() || this.complex.isInfinite()) {
            return this.complex;
        }
        ArrayList<Tensor> sum = new ArrayList<Tensor>();
        boolean isNumeric = this.complex.isNumeric();
        for (List nodes : this.summands.valueCollection()) {
            for (FactorNode node : nodes) {
                Tensor summand;
                if (isNumeric) {
                    summand = Tensors.multiply(ToNumericTransformation.toNumeric(node.build()), ToNumericTransformation.toNumeric(node.factor));
                    if (summand instanceof Complex) {
                        this.complex = this.complex.add((Complex)summand);
                        continue;
                    }
                    sum.add(summand);
                    continue;
                }
                summand = Tensors.multiply(node.build(), node.factor);
                if (TensorUtils.isZero(summand)) continue;
                sum.add(summand);
            }
        }
        if (sum.isEmpty()) {
            return this.complex;
        }
        if (!this.complex.isZero()) {
            sum.add(this.complex);
        }
        if (sum.size() == 1) {
            return (Tensor)sum.get(0);
        }
        return new Sum(sum.toArray(new Tensor[sum.size()]), this.indices);
    }

    protected abstract Split split(Tensor var1);

    @Override
    public void put(Tensor tensor) {
        if (this.complex.isNaN()) {
            return;
        }
        if (this.complex.isNumeric()) {
            tensor = ToNumericTransformation.toNumeric(tensor);
        }
        if (TensorUtils.isZero(tensor)) {
            return;
        }
        if (TensorUtils.isIndeterminate(tensor)) {
            this.complex = this.complex.add((Complex)tensor);
            return;
        }
        if (this.complex.isInfinite()) {
            if (tensor instanceof Complex) {
                this.complex.add((Complex)tensor);
            }
            return;
        }
        if (this.indices == null) {
            this.indices = IndicesFactory.create(tensor.getIndices().getFree());
            this.sortedFreeIndices = this.indices.getAllIndices().copy();
            Arrays.sort(this.sortedFreeIndices);
        } else if (!this.indices.equalsRegardlessOrder(tensor.getIndices().getFree())) {
            throw new TensorException("Inconsistent indices in sum. Expected: " + this.indices + " Actual: " + tensor.getIndices().getFree(), tensor);
        }
        if (tensor instanceof Sum) {
            for (Tensor s : tensor) {
                this.put(s);
            }
            return;
        }
        if (tensor instanceof Complex) {
            this.complex = this.complex.add((Complex)tensor);
            return;
        }
        Split split = this.split(tensor);
        Integer hash = TensorHashCalculator.hashWithIndices(split.factor, this.sortedFreeIndices);
        List factorNodes = (List)this.summands.get(hash.intValue());
        if (factorNodes == null) {
            ArrayList<FactorNode> fns = new ArrayList<FactorNode>();
            fns.add(new FactorNode(split.factor, split.getBuilder()));
            this.summands.put(hash.intValue(), fns);
        } else {
            Boolean b = null;
            for (FactorNode node : factorNodes) {
                b = AbstractSumBuilder.compareFactors(split.factor, node.factor);
                if (b == null) continue;
                if (b.booleanValue()) {
                    node.put(Tensors.negate(split.summand), split.factor);
                    break;
                }
                node.put(split.summand, split.factor);
                break;
            }
            if (b == null) {
                factorNodes.add(new FactorNode(split.factor, split.getBuilder()));
            }
        }
    }

    @Override
    public abstract TensorBuilder clone();

    static Boolean compareFactors(Tensor u, Tensor v) {
        return TensorUtils.compare1(u, v);
    }
}

