/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.solver.frobenius;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;

public class FrobeniusNumber {
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private static int ARRAY_SIZE_THRESHOLD_INT = 10000;
    private static BigInteger ARRAY_SIZE_THRESHOLD = BigInteger.valueOf(ARRAY_SIZE_THRESHOLD_INT);
    private static final BigInteger MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);

    public static BigInteger frobeniusNumber(int[] array) {
        BigInteger[] _array = new BigInteger[array.length];
        for (int i = array.length - 1; i >= 0; --i) {
            _array[i] = BigInteger.valueOf(array[i]);
        }
        return FrobeniusNumber.frobeniusNumber(_array);
    }

    public static BigInteger frobeniusNumber(long[] array) {
        BigInteger[] _array = new BigInteger[array.length];
        for (int i = array.length - 1; i >= 0; --i) {
            _array[i] = BigInteger.valueOf(array[i]);
        }
        return FrobeniusNumber.frobeniusNumber(_array);
    }

    public static BigInteger frobeniusNumber(BigInteger[] array) {
        if (array[0].compareTo(ARRAY_SIZE_THRESHOLD) > 0) {
            return FrobeniusNumber.frobeniusNumberIntegerArray(array);
        }
        return FrobeniusNumber.frobeniusNumberIntegerArray(array);
    }

    public static BigInteger frobeniusNumberBigIntArray(BigInteger[] array) {
        HashMap<BigInteger, BigInteger> ns = new HashMap<BigInteger, BigInteger>(ARRAY_SIZE_THRESHOLD_INT);
        ns.put(BigInteger.ZERO, BigInteger.ZERO);
        for (int i = 1; i < array.length; ++i) {
            BigInteger d = FrobeniusNumber.gcd(array[0], array[i]);
            BigInteger r = BigInteger.ZERO;
            while (r.compareTo(d) < 0) {
                BigInteger n = MINUS_ONE;
                if (r.compareTo(BigInteger.ZERO) == 0) {
                    n = BigInteger.ZERO;
                } else {
                    BigInteger q = r;
                    while (q.compareTo(array[0]) < 0) {
                        if (ns.containsKey(q) && (((BigInteger)ns.get(q)).compareTo(n) < 0 || n.equals(MINUS_ONE))) {
                            n = (BigInteger)ns.get(q);
                        }
                        q = q.add(d);
                    }
                }
                if (!n.equals(MINUS_ONE)) {
                    int size = FrobeniusNumber.intValue(array[0].divide(d));
                    for (int j = 0; j < size; ++j) {
                        BigInteger p = (n = n.add(array[i])).remainder(array[0]);
                        if (ns.containsKey(p) && (((BigInteger)ns.get(p)).compareTo(n) < 0 || n.equals(MINUS_ONE))) {
                            n = (BigInteger)ns.get(p);
                        }
                        ns.put(p, n);
                    }
                }
                r = r.add(BigInteger.ONE);
            }
        }
        BigInteger max = MINUS_ONE;
        for (BigInteger c : ns.values()) {
            if (c.compareTo(max) <= 0) continue;
            max = c;
        }
        return max.subtract(array[0]);
    }

    private static BigInteger frobeniusNumberIntegerArray(BigInteger[] array) {
        int array0 = FrobeniusNumber.intValue(array[0]);
        Object[] ns = new BigInteger[array0];
        Arrays.fill(ns, MINUS_ONE);
        ns[0] = BigInteger.ZERO;
        for (int i = 1; i < array.length; ++i) {
            int d = FrobeniusNumber.intValue(FrobeniusNumber.gcd(array[0], array[i]));
            for (int r = 0; r < d; ++r) {
                Object n = MINUS_ONE;
                if (r == 0) {
                    n = BigInteger.ZERO;
                } else {
                    for (int q = r; q < array0; q += d) {
                        if (((BigInteger)ns[q]).equals(MINUS_ONE) || ((BigInteger)ns[q]).compareTo((BigInteger)n) >= 0 && !((BigInteger)n).equals(MINUS_ONE)) continue;
                        n = ns[q];
                    }
                }
                if (((BigInteger)n).equals(MINUS_ONE)) continue;
                int size = array0 / d;
                for (int j = 0; j < size; ++j) {
                    int p = FrobeniusNumber.intValue(((BigInteger)(n = ((BigInteger)n).add(array[i]))).remainder(array[0]));
                    if (!((BigInteger)ns[p]).equals(MINUS_ONE) && (((BigInteger)ns[p]).compareTo((BigInteger)n) < 0 || ((BigInteger)n).equals(MINUS_ONE))) {
                        n = ns[p];
                    }
                    ns[p] = n;
                }
            }
        }
        Object max = BigInteger.ZERO;
        for (int i = 0; i < array0; ++i) {
            if (!((BigInteger)ns[i]).equals(MINUS_ONE) && ((BigInteger)ns[i]).compareTo((BigInteger)max) <= 0) continue;
            max = ns[i];
        }
        if (((BigInteger)max).equals(MINUS_ONE)) {
            return MINUS_ONE;
        }
        return ((BigInteger)max).subtract(array[0]);
    }

    private static BigInteger gcd(BigInteger a, BigInteger b) {
        return a.gcd(b);
    }

    private static int intValue(BigInteger integer) {
        if (integer.compareTo(MAX_VALUE) > 0) {
            throw new UnsupportedOperationException("Integer overflow.");
        }
        return integer.intValue();
    }
}

