/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.solver;

import cc.redberry.core.context.CC;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.number.Complex;
import cc.redberry.core.solver.ExternalSolver;
import cc.redberry.core.solver.ReducedSystem;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Split;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensorgenerator.GeneratedTensor;
import cc.redberry.core.tensorgenerator.TensorGenerator;
import cc.redberry.core.transformations.CollectNonScalarsTransformation;
import cc.redberry.core.transformations.EliminateMetricsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.TensorUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public final class InverseTensor {
    private final Expression[] equations;
    private final SimpleTensor[] unknownCoefficients;
    private final Expression generalInverse;

    public InverseTensor(Expression toInverse, Expression equation, Tensor[] samples) {
        this(toInverse, equation, samples, false, new Transformation[0]);
    }

    public InverseTensor(Expression toInverse, Expression equation, Tensor[] samples, boolean symmetricForm, Transformation[] transformations) {
        if (!(equation.get(0) instanceof Product)) {
            throw new IllegalArgumentException("Equation l.h.s. is not a product of tensors.");
        }
        Product leftEq = (Product)equation.get(0);
        SimpleTensor inverseLhs = null;
        for (Tensor t : leftEq) {
            if (IndexMappings.mappingExists(t, toInverse.get(0))) continue;
            inverseLhs = (SimpleTensor)t;
            break;
        }
        GeneratedTensor generatedTensor = TensorGenerator.generateStructure(inverseLhs.getIndices(), samples, symmetricForm, true, true);
        this.unknownCoefficients = generatedTensor.coefficients;
        this.generalInverse = Tensors.expression(inverseLhs, generatedTensor.generatedTensor);
        Tensor temp = equation;
        temp = toInverse.transform(temp);
        temp = this.generalInverse.transform(temp);
        transformations = ArraysUtils.addAll(new Transformation[]{EliminateMetricsTransformation.ELIMINATE_METRICS}, transformations);
        temp = ExpandTransformation.expand(temp, transformations);
        for (Transformation transformation : transformations) {
            temp = transformation.transform(temp);
        }
        equation = temp = CollectNonScalarsTransformation.collectNonScalars(temp);
        ArrayList<Split> rightSplit = new ArrayList<Split>();
        if (equation.get(1) instanceof Sum) {
            for (Tensor summand : equation.get(1)) {
                rightSplit.add(Split.splitScalars(summand));
            }
        } else {
            rightSplit.add(Split.splitScalars(equation.get(1)));
        }
        ArrayList<Expression> equationsList = new ArrayList<Expression>();
        for (Tensor summand : equation.get(0)) {
            Split current = Split.splitScalars(summand);
            boolean one = false;
            for (Split split : rightSplit) {
                if (!TensorUtils.equals(current.factor, split.factor)) continue;
                equationsList.add(Tensors.expression(current.summand, split.summand));
                one = true;
                break;
            }
            if (one) continue;
            equationsList.add(Tensors.expression(current.summand, Complex.ZERO));
        }
        this.equations = equationsList.toArray(new Expression[equationsList.size()]);
    }

    private static String newCoefficientName(Tensor ... tensors) {
        Set<SimpleTensor> simpleTensors = TensorUtils.getAllSymbols(tensors);
        ArrayList<Character> forbidden = new ArrayList<Character>();
        for (SimpleTensor tensor : simpleTensors) {
            String name = CC.getNameDescriptor(tensor.getName()).getName(tensor.getIndices());
            try {
                Integer.parseInt(name.substring(1));
                forbidden.add(Character.valueOf(name.charAt(0)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Collections.sort(forbidden);
        char c = 'a';
        for (int i = 0; i < forbidden.size() && c == ((Character)forbidden.get(i)).charValue(); c = (char)(c + '\u0001'), ++i) {
        }
        return String.valueOf(c);
    }

    public Expression[] getEquations() {
        return (Expression[])this.equations.clone();
    }

    public Expression getGeneralInverseForm() {
        return this.generalInverse;
    }

    public SimpleTensor[] getUnknownCoefficients() {
        return (SimpleTensor[])this.unknownCoefficients.clone();
    }

    public ReducedSystem toReducedSystem() {
        return new ReducedSystem(this.equations, this.unknownCoefficients, new Expression[]{this.generalInverse});
    }

    public static Expression findInverseWithMaple(Expression toInverse, Expression equation, Tensor[] samples, boolean symmetricForm, Transformation[] transformations, String mapleBinDir, String path) throws IOException, InterruptedException {
        return InverseTensor.findInverseWithMaple(toInverse, equation, samples, symmetricForm, false, transformations, mapleBinDir, path);
    }

    public static Expression findInverseWithMaple(Expression toInverse, Expression equation, Tensor[] samples, boolean symmetricForm, boolean keepFreeParameters, Transformation[] transformations, String mapleBinDir, String path) throws IOException, InterruptedException {
        ReducedSystem reducedSystem = new InverseTensor(toInverse, equation, samples, symmetricForm, transformations).toReducedSystem();
        return ExternalSolver.solveSystemWithExternalProgram(ExternalSolver.MapleScriptCreator.INSTANCE, reducedSystem, keepFreeParameters, mapleBinDir, path)[0][0];
    }

    public static Expression findInverseWithMathematica(Expression toInverse, Expression equation, Tensor[] samples, boolean symmetricForm, Transformation[] transformations, String mathematicaBinDir, String path) throws IOException, InterruptedException {
        return InverseTensor.findInverseWithMathematica(toInverse, equation, samples, symmetricForm, false, transformations, mathematicaBinDir, path);
    }

    public static Expression findInverseWithMathematica(Expression toInverse, Expression equation, Tensor[] samples, boolean symmetricForm, boolean keepFreeParameters, Transformation[] transformations, String mathematicaBinDir, String path) throws IOException, InterruptedException {
        ReducedSystem reducedSystem = new InverseTensor(toInverse, equation, samples, symmetricForm, transformations).toReducedSystem();
        return ExternalSolver.solveSystemWithExternalProgram(ExternalSolver.MathematicaScriptCreator.INSTANCE, reducedSystem, keepFreeParameters, mathematicaBinDir, path)[0][0];
    }
}

