/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.BracketsError;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.TokenParser;
import cc.redberry.core.parser.TokenType;
import java.util.Arrays;

public class ParserPowerAst
implements TokenParser {
    public static final ParserPowerAst INSTANCE = new ParserPowerAst();

    private ParserPowerAst() {
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        char[] expressionChars = expression.toCharArray();
        int level = 0;
        String argString = null;
        String powerString = null;
        for (int i = 0; i < expressionChars.length; ++i) {
            char c = expressionChars[i];
            if (c == '(' || c == '[') {
                ++level;
            }
            if (c == ')' || c == ']') {
                --level;
            }
            if (level < 0) {
                throw new BracketsError();
            }
            if (c != '*' || level != 0 || i + 1 >= expressionChars.length || expressionChars[i + 1] != '*') continue;
            argString = new String(Arrays.copyOfRange(expressionChars, 0, i));
            powerString = new String(Arrays.copyOfRange(expressionChars, i + 2, expressionChars.length));
            break;
        }
        if (argString == null) {
            return null;
        }
        ParseToken arg = parser.parse(argString);
        if (arg == null) {
            return null;
        }
        ParseToken power = parser.parse(powerString);
        if (power == null) {
            return null;
        }
        return new ParseToken(TokenType.Power, arg, power);
    }

    @Override
    public int priority() {
        return 990;
    }
}

