/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.context.CC;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.parser.BracketsError;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.utils.IntArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParserIndices {
    public static final Pattern pattern = Pattern.compile("((?>(?>[a-zA-Z])|(?>\\\\[a-zA-Z]*))(?>_(?>(?>[0-9])|(?>[\\{][0-9\\s]*[\\}])))?[']*)");

    public static SimpleIndices parseSimple(String expression) {
        return IndicesFactory.createSimple(null, ParserIndices.parse(expression));
    }

    public static int[] parse(String expression) {
        int endIndex;
        if (expression.isEmpty()) {
            return new int[0];
        }
        IntArrayList indices = new IntArrayList();
        int level = 0;
        int state = 0;
        char[] expressionChars = expression.toCharArray();
        int beginIndex = 0;
        for (endIndex = 0; endIndex < expressionChars.length; ++endIndex) {
            char c = expressionChars[endIndex];
            if (c == '{') {
                ++level;
                continue;
            }
            if (c == '}') {
                --level;
                continue;
            }
            if (c == '_' && level == 0) {
                if (endIndex != 0) {
                    ParserIndices.parse(expression.substring(beginIndex + 1, endIndex), indices, state);
                }
                state = 0;
                beginIndex = endIndex;
                continue;
            }
            if (c != '^') continue;
            if (level != 0) {
                throw new BracketsError();
            }
            if (endIndex != 0) {
                ParserIndices.parse(expression.substring(beginIndex + 1, endIndex), indices, state);
            }
            state = Integer.MIN_VALUE;
            beginIndex = endIndex;
        }
        if (level != 0) {
            throw new BracketsError();
        }
        if (beginIndex != endIndex) {
            ParserIndices.parse(expression.substring(beginIndex + 1, endIndex), indices, state);
        }
        return indices.toArray();
    }

    static void parse(String expression, IntArrayList indices, int state) {
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String singleIndex = matcher.group();
            indices.add(CC.getIndexConverterManager().getCode(singleIndex) | state);
        }
        String remainder = matcher.replaceAll("");
        if ((remainder = remainder.replaceAll("[\\{\\}\\s]*", "")).length() != 0) {
            throw new ParserException("Incorrect indices: " + expression);
        }
    }
}

