/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenExpression;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.TokenParser;

public class ParserExpression
implements TokenParser {
    public static final ParserExpression INSTANCE = new ParserExpression();

    private ParserExpression() {
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (!expression.contains("=")) {
            return null;
        }
        if (expression.indexOf(61) != expression.lastIndexOf(61)) {
            throw new ParserException("Several '=' symbols.");
        }
        String[] parts = expression.split("=");
        parts[0] = parts[0].trim();
        boolean preprocessing = false;
        if (parts[0].charAt(parts[0].length() - 1) == ':') {
            preprocessing = true;
            parts[0] = parts[0].substring(0, parts[0].length() - 1);
        }
        ParseToken left = parser.parse(parts[0]);
        ParseToken right = parser.parse(parts[1]);
        return new ParseTokenExpression(preprocessing, left, right);
    }

    @Override
    public int priority() {
        return 10100;
    }
}

