/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.BracketsError;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.TokenParser;

public class ParserBrackets
implements TokenParser {
    public static final ParserBrackets INSTANCE = new ParserBrackets();
    private static final int parserID = Integer.MAX_VALUE;

    private ParserBrackets() {
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (expression.charAt(0) == '(') {
            if (expression.charAt(expression.length() - 1) != ')') {
                this.checkWithException(expression);
            } else {
                int level = 0;
                for (int i = 0; i < expression.length(); ++i) {
                    char c = expression.charAt(i);
                    if (c == '(') {
                        ++level;
                    }
                    if (level < 1) {
                        return null;
                    }
                    if (c != ')') continue;
                    --level;
                }
                if (level != 0) {
                    throw new BracketsError();
                }
                return parser.parse(expression.substring(1, expression.length() - 1));
            }
        }
        return null;
    }

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }

    private void checkWithException(String expression) {
        int level = 0;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '(') {
                ++level;
            }
            if (c != ')') continue;
            --level;
        }
        if (level != 0) {
            throw new BracketsError(expression);
        }
    }
}

