/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.ParseTokenExpression;
import cc.redberry.core.parser.ParseTokenNumber;
import cc.redberry.core.parser.ParseTokenScalarFunction;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.ParseTokenTensorField;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.functions.ScalarFunction;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashSet;
import java.util.Set;

public class ParseUtils {
    private ParseUtils() {
    }

    public static boolean checkBracketsConsistence(String expression) {
        char[] expr = expression.toCharArray();
        int[] levels = new int[3];
        block8: for (char c : expr) {
            if (levels[0] < 0 || levels[1] < 0 || levels[2] < 0) {
                return false;
            }
            switch (c) {
                case '(': {
                    levels[0] = levels[0] + 1;
                    continue block8;
                }
                case ')': {
                    levels[0] = levels[0] - 1;
                    continue block8;
                }
                case '[': {
                    levels[1] = levels[1] + 1;
                    continue block8;
                }
                case ']': {
                    levels[1] = levels[1] - 1;
                    continue block8;
                }
                case '{': {
                    levels[2] = levels[2] + 1;
                    continue block8;
                }
                case '}': {
                    levels[2] = levels[2] - 1;
                    continue block8;
                }
            }
        }
        return levels[0] == 0 && levels[1] == 0 && levels[2] == 0;
    }

    public static ParseToken tensor2AST(Tensor tensor) {
        if (tensor instanceof TensorField) {
            TensorField tf = (TensorField)tensor;
            ParseToken[] content = new ParseToken[tf.size()];
            int i = 0;
            for (Tensor t : tf) {
                content[i++] = ParseUtils.tensor2AST(t);
            }
            return new ParseTokenTensorField(tf.getIndices(), tf.getStringName(), content, tf.getArgIndices());
        }
        if (tensor instanceof SimpleTensor) {
            SimpleTensor st = (SimpleTensor)tensor;
            return new ParseTokenSimpleTensor(st.getIndices(), st.getStringName());
        }
        if (tensor instanceof Complex) {
            return new ParseTokenNumber((Complex)tensor);
        }
        if (tensor instanceof Expression) {
            return new ParseTokenExpression(false, ParseUtils.tensor2AST(tensor.get(0)), ParseUtils.tensor2AST(tensor.get(1)));
        }
        ParseToken[] content = new ParseToken[tensor.size()];
        int i = 0;
        for (Tensor t : tensor) {
            content[i++] = ParseUtils.tensor2AST(t);
        }
        if (tensor instanceof ScalarFunction) {
            return new ParseTokenScalarFunction(tensor.getClass().getSimpleName(), content);
        }
        return new ParseToken(TokenType.valueOf(tensor.getClass().getSimpleName()), content);
    }

    public static Set<Integer> getAllIndices(ParseToken node) {
        HashSet<Integer> s = new HashSet<Integer>();
        ParseUtils.getAllIndices1(node, s);
        return s;
    }

    private static void getAllIndices1(ParseToken node, Set<Integer> set) {
        if (node instanceof ParseTokenSimpleTensor) {
            Indices indices = node.getIndices();
            for (int i = indices.size() - 1; i >= 0; --i) {
                set.add(IndicesUtils.getNameWithType(indices.get(i)));
            }
        } else {
            for (ParseToken pn : node.content) {
                if (pn instanceof ParseTokenScalarFunction) continue;
                ParseUtils.getAllIndices1(pn, set);
            }
        }
    }

    public static TIntSet getAllIndicesT(ParseToken node) {
        TIntHashSet set = new TIntHashSet();
        ParseUtils.getAllIndicesT1(node, (TIntSet)set);
        return set;
    }

    private static void getAllIndicesT1(ParseToken node, TIntSet set) {
        if (node instanceof ParseTokenSimpleTensor) {
            Indices indices = node.getIndices();
            for (int i = indices.size() - 1; i >= 0; --i) {
                set.add(IndicesUtils.getNameWithType(indices.get(i)));
            }
        } else {
            for (ParseToken pn : node.content) {
                if (pn instanceof ParseTokenScalarFunction) continue;
                ParseUtils.getAllIndicesT1(pn, set);
            }
        }
    }
}

