/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import java.util.Objects;

public class ParseTokenSimpleTensor
extends ParseToken {
    public SimpleIndices indices;
    public String name;

    protected ParseTokenSimpleTensor(SimpleIndices indices, String name, TokenType type, ParseToken[] content) {
        super(type, content);
        this.indices = indices;
        this.name = name;
    }

    public ParseTokenSimpleTensor(SimpleIndices indices, String name) {
        super(TokenType.SimpleTensor, new ParseToken[0]);
        this.indices = indices;
        this.name = name;
    }

    public NameAndStructureOfIndices getIndicesTypeStructureAndName() {
        return new NameAndStructureOfIndices(this.name, new StructureOfIndices[]{StructureOfIndices.create(this.indices)});
    }

    @Override
    public SimpleIndices getIndices() {
        return this.indices;
    }

    @Override
    public String toString() {
        return this.name + this.indices.toString();
    }

    @Override
    public Tensor toTensor() {
        return Tensors.simpleTensor(this.name, this.indices);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ParseTokenSimpleTensor other = (ParseTokenSimpleTensor)obj;
        if (!Objects.equals(this.indices, other.indices)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public boolean isKroneckerOrMetric() {
        return this.name.equals(CC.getNameManager().getKroneckerName()) || this.name.equals(CC.getNameManager().getMetricName());
    }

    public boolean isKronecker() {
        return this.name.equals(CC.getNameManager().getKroneckerName());
    }

    @Override
    public String toString(OutputFormat mode) {
        boolean external;
        StringBuilder sb = new StringBuilder();
        if (mode.is(OutputFormat.Maple) && this.isKroneckerOrMetric()) {
            if (this.isKronecker()) {
                sb.append("KroneckerDelta");
            } else {
                sb.append("g_");
            }
        } else {
            sb.append(this.name);
        }
        if (this.indices.size() == 0) {
            return sb.toString();
        }
        boolean bl = external = mode.is(OutputFormat.WolframMathematica) || mode.is(OutputFormat.Maple);
        if (external) {
            sb.append("[");
        }
        sb.append(this.indices.toString(mode));
        if (external) {
            sb.append("]");
        }
        return sb.toString();
    }
}

