/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.transformations.DifferentiateTransformation;
import cc.redberry.core.transformations.ExpandAndEliminateTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;

public class ParseTokenDerivative
extends ParseToken {
    Indices indices;

    public ParseTokenDerivative(TokenType tokenType, ParseToken ... content) {
        super(tokenType, content);
        IndicesBuilder ib = new IndicesBuilder();
        ib.append(content[0].getIndices().getFree());
        for (int i = content.length - 1; i >= 1; --i) {
            ib.append(content[i].getIndices().getInverted().getFree());
        }
        this.indices = ib.getIndices();
    }

    @Override
    public Indices getIndices() {
        return this.indices;
    }

    @Override
    public Tensor toTensor() {
        SimpleTensor[] vars = new SimpleTensor[this.content.length - 1];
        Tensor temp = this.content[0].toTensor();
        TIntHashSet allowedDummies = TensorUtils.getAllIndicesNamesT(temp);
        IndicesBuilder free = new IndicesBuilder().append(temp.getIndices());
        for (int i = 1; i < this.content.length; ++i) {
            temp = this.content[i].toTensor();
            free.append(temp.getIndices().getInverted());
            allowedDummies.addAll(IndicesUtils.getIndicesNames(temp.getIndices()));
            if (!(temp instanceof SimpleTensor) && !(temp instanceof TensorField)) {
                throw new IllegalArgumentException("Derivative with respect to non simple argument: " + temp);
            }
            vars[i - 1] = (SimpleTensor)temp;
        }
        allowedDummies.removeAll(IndicesUtils.getIndicesNames(free.getIndices().getFree()));
        Tensor result = new DifferentiateTransformation(vars, new Transformation[]{ExpandAndEliminateTransformation.EXPAND_AND_ELIMINATE}).transform(this.content[0].toTensor());
        result = ApplyIndexMapping.optimizeDummies(result);
        TIntHashSet generated = TensorUtils.getAllDummyIndicesT(result);
        generated.removeAll((TIntCollection)allowedDummies);
        result = ApplyIndexMapping.renameDummy(result, generated.toArray(), allowedDummies.toArray());
        return result;
    }
}

