/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number.parser;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Number;
import cc.redberry.core.number.Rational;
import cc.redberry.core.number.Real;
import cc.redberry.core.number.parser.BracketToken;
import cc.redberry.core.number.parser.ComplexToken;
import cc.redberry.core.number.parser.OperatorToken;
import cc.redberry.core.number.parser.RealToken;
import cc.redberry.core.number.parser.TokenParser;

public class NumberParser<T extends Number<T>> {
    private static final TokenParser<Complex>[] ComplexTokens = new TokenParser[]{BracketToken.INSTANCE, new OperatorToken<Complex>('+', '-'){

        @Override
        protected Complex neutral() {
            return Complex.ZERO;
        }

        @Override
        protected Complex operation(Complex c1, Complex c2, boolean mode) {
            if (mode) {
                return c1.subtract(c2);
            }
            return c1.add(c2);
        }
    }, new OperatorToken<Complex>('*', '/'){

        @Override
        protected Complex neutral() {
            return Complex.ONE;
        }

        @Override
        protected Complex operation(Complex c1, Complex c2, boolean mode) {
            if (mode) {
                return c1.divide(c2);
            }
            return c1.multiply(c2);
        }
    }, ComplexToken.INSTANCE};
    private static final TokenParser<Real>[] RealTokens = new TokenParser[]{BracketToken.INSTANCE, new OperatorToken<Real>('+', '-'){

        @Override
        protected Real neutral() {
            return Rational.ZERO;
        }

        @Override
        protected Real operation(Real c1, Real c2, boolean mode) {
            if (mode) {
                return (Real)c1.subtract(c2);
            }
            return (Real)c1.add(c2);
        }
    }, new OperatorToken<Real>('*', '/'){

        @Override
        protected Real neutral() {
            return Rational.ONE;
        }

        @Override
        protected Real operation(Real c1, Real c2, boolean mode) {
            if (mode) {
                return (Real)c1.divide(c2);
            }
            return (Real)c1.multiply(c2);
        }
    }, RealToken.INSTANCE};
    public static final NumberParser<Real> REAL_PARSER = new NumberParser<Real>(RealTokens);
    public static final NumberParser<Complex> COMPLEX_PARSER = new NumberParser<Complex>(ComplexTokens);
    private final TokenParser<T>[] parsers;

    private NumberParser(TokenParser<T>[] parsers) {
        this.parsers = parsers;
    }

    public T parse(String expression) {
        expression = expression.trim();
        for (TokenParser<T> parser : this.parsers) {
            T element = parser.parse(expression, this);
            if (element == null) continue;
            return element;
        }
        throw new NumberFormatException();
    }
}

