/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number.parser;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.parser.NumberParser;
import cc.redberry.core.number.parser.TokenParser;
import java.math.BigInteger;

public class ComplexToken
implements TokenParser<Complex> {
    public static final ComplexToken INSTANCE = new ComplexToken();

    private ComplexToken() {
    }

    @Override
    public Complex parse(String expression, NumberParser<Complex> parser) {
        if (expression.equals("I")) {
            return Complex.IMAGINARY_UNIT;
        }
        try {
            return new Complex(new BigInteger(expression));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Complex(Double.parseDouble(expression));
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }
    }
}

