/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.combinatorics.IntPermutationsGenerator;
import cc.redberry.core.indexmapping.DummyIndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferImpl;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderFactory;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.MinusIndexMappingProviderWrapper;
import cc.redberry.core.indexmapping.PermutatorProvider;
import cc.redberry.core.indexmapping.SimpleProductMappingsPort;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.OutputPort;
import cc.redberry.core.utils.stretces.PrecalculatedStretches;
import cc.redberry.core.utils.stretces.Stretch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

final class ProviderProduct
implements IndexMappingProvider {
    static final IndexMappingProviderFactory FACTORY = new IndexMappingProviderFactory(){

        @Override
        public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
            Tensor[] toScalars;
            Product pfrom = (Product)from;
            Product pto = (Product)to;
            if (pfrom.sizeWithoutFactor() != pto.sizeWithoutFactor()) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            Boolean booluon = ProviderProduct.compareFactors(pfrom.getFactor(), pto.getFactor());
            if (booluon == null) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            if (pfrom.getFactor().equals(pto.getFactor())) {
                for (int i = 0; i < pfrom.sizeWithoutFactor(); ++i) {
                    if (pfrom.getWithoutFactor(i).hashCode() == pto.getWithoutFactor(i).hashCode()) continue;
                    return IndexMappingProvider.Util.EMPTY_PROVIDER;
                }
            }
            ProductContent fromContent = pfrom.getContent();
            ProductContent toContent = pto.getContent();
            if (!fromContent.getStructureOfContractionsHashed().equals(toContent.getStructureOfContractionsHashed())) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            Tensor[] fromScalars = pfrom.getAllScalarsWithoutFactor();
            if (fromScalars.length != (toScalars = pto.getAllScalarsWithoutFactor()).length) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            if (fromScalars.length != 1 && !ProviderProduct.testScalars(fromScalars, toScalars)) {
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            if (booluon.booleanValue()) {
                return new MinusIndexMappingProviderWrapper(new ProviderProduct(opu, pfrom, pto));
            }
            return new ProviderProduct(opu, pfrom, pto);
        }
    };
    private final DummyIndexMappingProvider dummyProvider;
    private final OutputPort<IndexMappingBuffer> op;

    private static Boolean compareFactors(Complex c1, Complex c2) {
        if (c1.equals(c2)) {
            return Boolean.FALSE;
        }
        if (c1.equals(c2.negate())) {
            return Boolean.TRUE;
        }
        return null;
    }

    private static boolean testScalars(Tensor[] from, Tensor[] to) {
        int i;
        if (from.length != to.length) {
            return false;
        }
        int[] hashes = new int[from.length];
        for (i = 0; i < from.length; ++i) {
            hashes[i] = from[i].hashCode();
            if (hashes[i] == to[i].hashCode()) continue;
            return false;
        }
        PrecalculatedStretches precalculatedStretches = new PrecalculatedStretches(hashes);
        for (Stretch stretch : precalculatedStretches) {
            if (stretch.length != 1 || ProviderProduct.mappingExists(from[stretch.from], to[stretch.from])) continue;
            return false;
        }
        block2: for (Stretch stretch : precalculatedStretches) {
            if (stretch.length <= 1) continue;
            block3: for (int[] permutation : new IntPermutationsGenerator(stretch.length)) {
                for (i = 0; i < stretch.length; ++i) {
                    if (!ProviderProduct.mappingExists(from[stretch.from + i], to[stretch.from + permutation[i]])) continue block3;
                }
                continue block2;
            }
            return false;
        }
        return true;
    }

    private static boolean mappingExists(Tensor from, Tensor to) {
        IndexMappingProvider pp = IndexMappings.createPort(IndexMappingProvider.Util.singleton(new IndexMappingBufferImpl()), from, to);
        pp.tick();
        return pp.take() != null;
    }

    private ProviderProduct(OutputPort<IndexMappingBuffer> opu, Product from, Product to) {
        int i;
        this.dummyProvider = new DummyIndexMappingProvider(opu);
        int begin = 0;
        ProductContent fromContent = from.getContent();
        ProductContent toContent = to.getContent();
        ArrayList<Pair> stretches = new ArrayList<Pair>();
        ArrayList<IndexMappingProvider> providers = new ArrayList<IndexMappingProvider>();
        IndexMappingProvider lastOutput = this.dummyProvider;
        Tensor[] indexlessFrom = from.getIndexless();
        Tensor[] indexlessTo = to.getIndexless();
        for (i = 1; i <= indexlessFrom.length; ++i) {
            if (i != indexlessFrom.length && indexlessFrom[i].hashCode() == indexlessFrom[i - 1].hashCode()) continue;
            if (i - 1 != begin) {
                lastOutput = new PermutatorProvider(lastOutput, Arrays.copyOfRange(indexlessFrom, begin, i), Arrays.copyOfRange(indexlessTo, begin, i));
                providers.add(lastOutput);
            }
            begin = i;
        }
        begin = 0;
        for (i = 1; i <= indexlessFrom.length; ++i) {
            if (i != indexlessFrom.length && indexlessFrom[i].hashCode() == indexlessFrom[i - 1].hashCode()) continue;
            if (i - 1 == begin) {
                lastOutput = IndexMappings.createPort(lastOutput, indexlessFrom[begin], indexlessTo[begin]);
                providers.add(lastOutput);
            }
            begin = i;
        }
        begin = 0;
        for (i = 1; i <= fromContent.size(); ++i) {
            if (i != fromContent.size() && fromContent.getStructureOfContractionsHashed().get(i).equals(fromContent.getStructureOfContractionsHashed().get(i - 1))) continue;
            if (i - 1 != begin) {
                stretches.add(new Pair(fromContent.getRange(begin, i), toContent.getRange(begin, i)));
            } else {
                lastOutput = IndexMappings.createPort(lastOutput, fromContent.get(begin), toContent.get(begin));
                providers.add(lastOutput);
            }
            begin = i;
        }
        Collections.sort(stretches);
        for (Pair p : stretches) {
            lastOutput = new PermutatorProvider(lastOutput, p.from, p.to);
            providers.add(lastOutput);
        }
        this.op = new SimpleProductMappingsPort(providers.toArray(new IndexMappingProvider[providers.size()]));
    }

    @Override
    public boolean tick() {
        return this.dummyProvider.tick();
    }

    @Override
    public IndexMappingBuffer take() {
        IndexMappingBuffer buffer = this.op.take();
        if (buffer == null) {
            return null;
        }
        buffer.removeContracted();
        return buffer;
    }

    protected static class Pair
    implements Comparable<Pair> {
        public final Tensor[] from;
        public final Tensor[] to;

        public Pair(Tensor[] from, Tensor[] to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public int compareTo(Pair o) {
            return Integer.compare(this.from.length, o.from.length);
        }
    }
}

